/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.bookmark;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkVisitor;

public class BookmarkFolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long m_id;
    private String m_title;
    private String m_iconId;
    private final List<BookmarkFolder> m_folders;
    private final List<Bookmark> m_bookmarks;
    private Bookmark m_startupBookmark;

    public BookmarkFolder() {
        this.m_folders = new ArrayList<BookmarkFolder>();
        this.m_bookmarks = new ArrayList<Bookmark>();
    }

    protected BookmarkFolder(BookmarkFolder other) {
        this.m_id = other.m_id;
        this.m_title = other.m_title;
        this.m_iconId = other.m_iconId;
        this.m_folders = new ArrayList<BookmarkFolder>();
        for (BookmarkFolder f : other.m_folders) {
            this.m_folders.add(f.copy());
        }
        this.m_bookmarks = new ArrayList<Bookmark>();
        for (Bookmark b : other.m_bookmarks) {
            this.m_bookmarks.add(b.copy());
        }
        if (other.m_startupBookmark != null) {
            this.m_startupBookmark = other.m_startupBookmark.copy();
        }
    }

    public long getId() {
        return this.m_id;
    }

    public void setId(long id) {
        this.m_id = id;
    }

    public String getIconId() {
        return this.m_iconId;
    }

    public void setIconId(String iconid) {
        this.m_iconId = iconid;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String s) {
        this.m_title = s;
    }

    public Bookmark getStartupBookmark() {
        return this.m_startupBookmark;
    }

    public void setStartupBookmark(Bookmark startupBookmark) {
        this.m_startupBookmark = startupBookmark;
    }

    public void addBookmarks(BookmarkFolder folder, boolean replaceDuplicates, boolean byReference) {
        if (folder == null) {
            return;
        }
        for (Bookmark b : folder.getBookmarks()) {
            Bookmark existingBm;
            if (!byReference) {
                b = b.copy();
            }
            if (replaceDuplicates && (existingBm = this.getBookmark(b.getTitle())) != null) {
                this.getBookmarks().remove(existingBm);
            }
            this.getBookmarks().add(b);
        }
        for (BookmarkFolder subFolder : folder.getFolders()) {
            BookmarkFolder existingFolder = this.getFolder(subFolder.getTitle());
            if (existingFolder == null) {
                if (byReference) {
                    existingFolder = subFolder;
                    this.getFolders().add(existingFolder);
                    continue;
                }
                existingFolder = subFolder.copy();
                this.getFolders().add(existingFolder);
                continue;
            }
            existingFolder.addBookmarks(subFolder, replaceDuplicates, byReference);
        }
    }

    public List<BookmarkFolder> getFolders() {
        return this.m_folders;
    }

    public List<Bookmark> getBookmarks() {
        return this.m_bookmarks;
    }

    public Bookmark getBookmark(String title) {
        for (Bookmark b : this.getBookmarks()) {
            if (!ObjectUtility.equals((Object)b.getTitle(), (Object)title)) continue;
            return b;
        }
        return null;
    }

    public BookmarkFolder getFolder(String title) {
        for (BookmarkFolder f : this.getFolders()) {
            if (!ObjectUtility.equals((Object)f.getTitle(), (Object)title)) continue;
            return f;
        }
        return null;
    }

    public BookmarkFolder copy() {
        return new BookmarkFolder(this);
    }

    public boolean visit(IBookmarkVisitor v) {
        ArrayList<BookmarkFolder> path = new ArrayList<BookmarkFolder>();
        return this.visitInternal(v, path);
    }

    boolean visitInternal(IBookmarkVisitor v, List<BookmarkFolder> path) {
        boolean result = true;
        try {
            path.add(this);
            result = v.visitFolder(path);
            if (!result) {
                boolean bl = result;
                return bl;
            }
            for (Bookmark b : new ArrayList<Bookmark>(this.getBookmarks())) {
                result = v.visitBookmark(path, b);
                if (result) continue;
                boolean bl = result;
                return bl;
            }
            for (BookmarkFolder f : new ArrayList<BookmarkFolder>(this.getFolders())) {
                result = f.visitInternal(v, path);
                if (result) continue;
                boolean bl = result;
                return bl;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            path.remove(this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_iconId == null ? 0 : this.m_iconId.hashCode());
        result = 31 * result + (int)(this.m_id ^ this.m_id >>> 32);
        result = 31 * result + (this.m_title == null ? 0 : this.m_title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BookmarkFolder other = (BookmarkFolder)obj;
        if (this.m_iconId == null ? other.m_iconId != null : !this.m_iconId.equals(other.m_iconId)) {
            return false;
        }
        if (this.m_id != other.m_id) {
            return false;
        }
        return !(this.m_title == null ? other.m_title != null : !this.m_title.equals(other.m_title));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " title=" + this.getTitle() + ", id=" + this.getId() + "]";
    }
}

