/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.bookmark;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.serialization.SerializationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.services.common.bookmark.AbstractPageState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bookmark
implements Serializable,
IOrdered {
    private static final Logger LOG = LoggerFactory.getLogger(Bookmark.class);
    private static final long serialVersionUID = 1L;
    public static final int USER_BOOKMARK = 1;
    public static final int GLOBAL_BOOKMARK = 2;
    public static final String SPOOL_FOLDER_NAME = "[SPOOL]";
    public static final String INBOX_FOLDER_NAME = "[INBOX]";
    private long m_id;
    private int m_kind;
    private boolean m_new;
    private String m_title;
    private String m_text;
    private String m_keyStroke;
    private String m_outlineClassName;
    private List<AbstractPageState> m_path;
    private String m_iconId;
    private double m_order;
    private transient byte[] m_serializedData;

    public Bookmark() {
    }

    public Bookmark(Bookmark bm) {
        this.importData(bm);
    }

    private void importData(Bookmark bm) {
        this.m_kind = bm.m_kind;
        this.m_title = bm.m_title;
        this.m_text = bm.m_text;
        this.m_iconId = bm.m_iconId;
        this.m_order = bm.m_order;
        this.m_keyStroke = bm.m_keyStroke;
        this.m_outlineClassName = bm.m_outlineClassName;
        if (bm.m_path != null) {
            this.m_path = new ArrayList<AbstractPageState>();
            for (AbstractPageState state : bm.m_path) {
                this.m_path.add(state.copy());
            }
        }
        this.m_serializedData = null;
    }

    public String getIconId() {
        return this.m_iconId;
    }

    public void setIconId(String iconid) {
        this.m_iconId = iconid;
        this.m_serializedData = null;
    }

    public double getOrder() {
        return this.m_order;
    }

    public void setOrder(double order) {
        this.m_order = order;
        this.m_serializedData = null;
    }

    public long getId() {
        return this.m_id;
    }

    public void setId(long id) {
        this.m_id = id;
    }

    public int getKind() {
        return this.m_kind;
    }

    public void setKind(int kind) {
        switch (kind) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid kind: " + kind);
            }
        }
        this.m_kind = kind;
        this.m_serializedData = null;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String s) {
        this.m_title = s;
        this.m_serializedData = null;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String s) {
        this.m_text = s;
        this.m_serializedData = null;
    }

    public String getKeyStroke() {
        return this.m_keyStroke;
    }

    public void setKeyStroke(String s) {
        this.m_keyStroke = s;
        this.m_serializedData = null;
    }

    public boolean isNew() {
        return this.m_new;
    }

    public void setNew(boolean bookmarkIsUnread) {
        this.m_new = bookmarkIsUnread;
    }

    public String getOutlineClassName() {
        return this.m_outlineClassName;
    }

    public void setOutlineClassName(String s) {
        this.m_outlineClassName = s;
        this.m_serializedData = null;
    }

    public List<AbstractPageState> getPath() {
        return CollectionUtility.arrayList(this.m_path);
    }

    public void addPathElement(AbstractPageState state) {
        if (this.m_path == null) {
            this.m_path = new ArrayList<AbstractPageState>();
        }
        this.m_path.add(state);
        this.m_serializedData = null;
    }

    public byte[] getSerializedData() {
        if (this.m_serializedData == null) {
            try {
                this.m_serializedData = SerializationUtility.createObjectSerializer().serialize((Object)this);
            }
            catch (IOException e) {
                throw new ProcessingException("title: " + this.getTitle(), new Object[]{e});
            }
        }
        return this.m_serializedData;
    }

    public void setSerializedData(byte[] data) {
        try {
            Bookmark bm = (Bookmark)SerializationUtility.createObjectSerializer().deserialize(data, Bookmark.class);
            this.importData(bm);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ProcessingException("title: " + this.getTitle(), new Object[]{e});
        }
        this.m_serializedData = data;
    }

    public Bookmark copy() {
        return new Bookmark(this);
    }

    private long getCRC() {
        CRC32 crc = new CRC32();
        try {
            byte[] a = this.getSerializedData();
            if (a != null) {
                crc.update(a);
            }
        }
        catch (RuntimeException e) {
            LOG.warn("CRC computation failed", (Throwable)e);
        }
        return crc.getValue();
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Bookmark other = (Bookmark)o;
        return this.getCRC() == other.getCRC();
    }

    public String toString() {
        return "Bookmark[title=" + this.getTitle() + ", id=" + this.getId() + ", kind=" + (this.getKind() == 2 ? "Global" : "User") + "]";
    }
}

