/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.security;

import java.util.regex.Pattern;
import org.eclipse.scout.rt.api.data.security.PermissionId;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.security.AbstractPermission;
import org.eclipse.scout.rt.security.IPermission;
import org.eclipse.scout.rt.security.IPermissionCollection;

public class RemoteServiceAccessPermission
extends AbstractPermission {
    private static final long serialVersionUID = 1L;
    public static final PermissionId ID = PermissionId.of((String)"scout.remote.service.access");
    private final String m_serviceOperation;
    private transient Pattern m_pattern;

    public RemoteServiceAccessPermission() {
        this(null);
    }

    public RemoteServiceAccessPermission(String interfaceTypeName, String methodName) {
        this(interfaceTypeName.replace('$', '.') + "#" + methodName);
    }

    protected RemoteServiceAccessPermission(String serviceOperation) {
        super(ID);
        this.m_serviceOperation = serviceOperation;
    }

    public String getServiceOperation() {
        return this.m_serviceOperation;
    }

    public String getServiceOperationPattern() {
        return this.m_serviceOperation.replace(".", "[.]").replace("*", ".*");
    }

    protected boolean evalPermission(IPermission p) {
        RemoteServiceAccessPermission other;
        if (this.m_pattern == null) {
            this.m_pattern = Pattern.compile(this.getServiceOperationPattern());
        }
        if ((other = (RemoteServiceAccessPermission)p).getServiceOperation() == null) {
            return false;
        }
        return this.m_pattern.matcher(other.getServiceOperation()).matches();
    }

    protected void validate(IPermissionCollection permissionCollection) {
        super.validate(permissionCollection);
        this.validateServiceOperationPattern();
    }

    protected void validateServiceOperationPattern() {
        Assertions.assertNotNull((Object)this.getServiceOperation(), (String)"Service operation pattern must not be null when assigned to a permission collection {}", (Object[])new Object[]{this});
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_serviceOperation == null ? 0 : this.m_serviceOperation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RemoteServiceAccessPermission other = (RemoteServiceAccessPermission)((Object)obj);
        return !(this.m_serviceOperation == null ? other.m_serviceOperation != null : !this.m_serviceOperation.equals(other.m_serviceOperation));
    }
}

