/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.opentelemetry;

import io.opentelemetry.api.trace.Span;
import org.eclipse.scout.rt.platform.chain.callable.ICallableDecorator;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.opentelemetry.OpenTelemetryContextProcessor;
import org.eclipse.scout.rt.platform.opentelemetry.OpenTelemetryProperties;
import org.eclipse.scout.rt.shared.ISession;

public class OpenTelemetrySpanAttributeProcessor
implements ICallableDecorator {
    public ICallableDecorator.IUndecorator decorate() throws Exception {
        if (!((Boolean)CONFIG.getPropertyValue(OpenTelemetryProperties.OpenTelemetrySpanAttributeProcessorEnabledProperty.class)).booleanValue()) {
            return OpenTelemetryContextProcessor.NOOP;
        }
        Span current = Span.current();
        if (Span.getInvalid() == current) {
            return OpenTelemetryContextProcessor.NOOP;
        }
        current.setAttribute(this.getUserIdKey(), this.getUserIdValue());
        return () -> {
            Span span2 = current.setAttribute(this.getUserIdKey(), null);
        };
    }

    protected String getUserIdKey() {
        return "user.name";
    }

    protected String getUserIdValue() {
        ISession currentSession = ISession.CURRENT.get();
        return currentSession != null ? currentSession.getUserId() : null;
    }
}

