/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.opentelemetry.OpenTelemetryProperties;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;

@ApplicationScoped
public class HttpServiceTunnelInstrumenterFactory {
    public static final String INSTRUMENTATION_NAME = "scout.HttpServiceTunnel";
    private static final String SCOUT_PREFIX = "scout.server.service";
    public static final AttributeKey<String> REQUEST_NAME = AttributeKey.stringKey((String)"scout.server.service.name");
    public static final AttributeKey<String> OPERATION = AttributeKey.stringKey((String)"scout.server.service.operation");
    public static final AttributeKey<String> PARAMETER_TYPES = AttributeKey.stringKey((String)"scout.server.service.parameter.types");

    public Instrumenter<ServiceTunnelRequest, Void> createInstrumenter() {
        SpanNameExtractor spanNameExtractor = serviceTunnelRequest -> {
            String fullName = serviceTunnelRequest.getServiceInterfaceClassName();
            String serviceName = fullName.substring(fullName.lastIndexOf(46) + 1);
            return "TUNNEL " + serviceName + "." + serviceTunnelRequest.getOperation();
        };
        AttributesExtractor<ServiceTunnelRequest, Void> attributesExtractor = new AttributesExtractor<ServiceTunnelRequest, Void>(){

            public void onStart(AttributesBuilder attributes, Context parentContext, ServiceTunnelRequest serviceTunnelRequest) {
                attributes.put(REQUEST_NAME, (Object)serviceTunnelRequest.getServiceInterfaceClassName());
                attributes.put(OPERATION, (Object)serviceTunnelRequest.getOperation());
                attributes.put(PARAMETER_TYPES, (Object)Arrays.toString(serviceTunnelRequest.getParameterTypes()));
            }

            public void onEnd(AttributesBuilder attributes, Context context, ServiceTunnelRequest serviceTunnelRequest, @Nullable Void unused, @Nullable Throwable error) {
            }
        };
        return Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)INSTRUMENTATION_NAME, (SpanNameExtractor)spanNameExtractor).addAttributesExtractor((AttributesExtractor)attributesExtractor).setEnabled(((Boolean)CONFIG.getPropertyValue(OpenTelemetryProperties.OpenTelemetryTracingEnabledProperty.class)).booleanValue()).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }
}

