/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.notification;

import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.util.List;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.TypeParameterBeanRegistry;
import org.eclipse.scout.rt.shared.clientnotification.IClientNotificationAddress;
import org.eclipse.scout.rt.shared.clientnotification.IDispatchingNotificationHandler;
import org.eclipse.scout.rt.shared.notification.INotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class NotificationHandlerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationHandlerRegistry.class);
    private final TypeParameterBeanRegistry<INotificationHandler> m_notificationHandlerRegistry = new TypeParameterBeanRegistry(INotificationHandler.class);
    private final TypeParameterBeanRegistry<IDispatchingNotificationHandler> m_dispatchingNotificationHandlerRegistry = new TypeParameterBeanRegistry(IDispatchingNotificationHandler.class);

    @PostConstruct
    protected void buildHandlerLinking() {
        this.m_notificationHandlerRegistry.registerBeans(BEANS.all(INotificationHandler.class));
        this.m_dispatchingNotificationHandlerRegistry.registerBeans(BEANS.all(IDispatchingNotificationHandler.class));
    }

    public void notifyHandlers(Serializable notification, IClientNotificationAddress address) {
        this.notifyNotificationHandlers(notification);
        this.notifyDispatchingNotificationHandlers(notification, address);
    }

    public void notifyDispatchingNotificationHandlers(Serializable notification, IClientNotificationAddress address) {
        List dispatchingHandlers = this.m_dispatchingNotificationHandlerRegistry.getBeans(notification.getClass());
        for (IDispatchingNotificationHandler handler : dispatchingHandlers) {
            try {
                handler.handleNotification(notification, address);
            }
            catch (RuntimeException e) {
                LOG.error("Handler '{}' notification with notification '{}' failed.", new Object[]{handler, notification, e});
            }
        }
    }

    public void notifyNotificationHandlers(Serializable notification) {
        List handlers = this.m_notificationHandlerRegistry.getBeans(notification.getClass());
        for (INotificationHandler handler : handlers) {
            try {
                handler.handleNotification(notification);
            }
            catch (RuntimeException e) {
                LOG.error("Handler '{}' notification with notification '{}' failed.", new Object[]{handler, notification, e});
            }
        }
    }
}

