/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.job.filter.future;

import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.util.IAdaptable;
import org.eclipse.scout.rt.shared.ISession;

public class SessionFutureFilter
implements Predicate<IFuture<?>>,
IAdaptable {
    private final ISession m_session;

    public SessionFutureFilter(ISession session) {
        this.m_session = session;
    }

    @Override
    public boolean test(IFuture<?> future) {
        RunContext runContext = future.getJobInput().getRunContext();
        if (runContext == null) {
            return false;
        }
        ISession session = (ISession)runContext.getAdapter(ISession.class);
        if (session == null) {
            return false;
        }
        return this.m_session == session;
    }

    public <T> T getAdapter(Class<T> type) {
        if (ISession.class.isAssignableFrom(type)) {
            return (T)this.m_session;
        }
        return null;
    }
}

