/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.transport;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.eclipse.scout.rt.shared.http.transport.ApacheHttpRequest;

public class ApacheHttpTransport
extends HttpTransport {
    private final HttpClient m_httpClient;

    public ApacheHttpTransport(HttpClient httpClient) {
        this.m_httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.m_httpClient;
    }

    protected LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
        HttpGet req;
        if (method == null) {
            return null;
        }
        if ("GET".equalsIgnoreCase(method)) {
            req = new HttpGet(url);
        } else if ("POST".equalsIgnoreCase(method)) {
            req = new HttpPost(url);
        } else if ("PUT".equalsIgnoreCase(method)) {
            req = new HttpPut(url);
        } else if ("DELETE".equalsIgnoreCase(method)) {
            req = new HttpDelete(url);
        } else if ("OPTIONS".equalsIgnoreCase(method)) {
            req = new HttpOptions(url);
        } else if ("HEAD".equalsIgnoreCase(method)) {
            req = new HttpHead(url);
        } else if ("PATCH".equalsIgnoreCase(method)) {
            req = new HttpPatch(url);
        } else {
            throw new UnsupportedOperationException("Unknown request method: " + method);
        }
        return this.createRequestInternal((HttpUriRequestBase)req);
    }

    protected ApacheHttpRequest createRequestInternal(HttpUriRequestBase req) {
        return new ApacheHttpRequest(this.m_httpClient, req);
    }

    public void shutdown() throws IOException {
        HttpClient httpClient = this.getHttpClient();
        if (httpClient instanceof Closeable) {
            ((Closeable)httpClient).close();
        }
    }
}

