/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.transport;

import com.google.api.client.http.LowLevelHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class ApacheHttpResponse
extends LowLevelHttpResponse {
    private final HttpUriRequestBase m_request;
    private final ClassicHttpResponse m_response;

    public ApacheHttpResponse(HttpUriRequestBase request, ClassicHttpResponse response) {
        this.m_request = request;
        this.m_response = response;
    }

    public InputStream getContent() throws IOException {
        HttpEntity entity = this.m_response.getEntity();
        return entity != null ? entity.getContent() : null;
    }

    public String getContentEncoding() {
        HttpEntity entity = this.m_response.getEntity();
        String contentEncoding = entity != null ? entity.getContentEncoding() : null;
        return contentEncoding;
    }

    public long getContentLength() throws IOException {
        HttpEntity entity = this.m_response.getEntity();
        return entity != null ? entity.getContentLength() : 0L;
    }

    public String getContentType() throws IOException {
        HttpEntity entity = this.m_response.getEntity();
        String contentType = entity != null ? entity.getContentType() : null;
        return contentType;
    }

    public String getStatusLine() throws IOException {
        return StringUtility.join((String)" ", (Object[])new Object[]{this.getStatusCode(), this.getReasonPhrase()});
    }

    public int getStatusCode() throws IOException {
        return this.m_response.getCode();
    }

    public String getReasonPhrase() {
        return this.m_response.getReasonPhrase();
    }

    public int getHeaderCount() {
        return this.m_response.getHeaders().length;
    }

    public String getHeaderName(int index) {
        return this.m_response.getHeaders()[index].getName();
    }

    public String getHeaderValue(int index) {
        return this.m_response.getHeaders()[index].getValue();
    }

    public void disconnect() throws IOException {
        this.m_request.abort();
    }
}

