/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.transport;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.util.StreamingContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.eclipse.scout.rt.shared.http.transport.ApacheHttpResponse;

public class ApacheHttpRequest
extends LowLevelHttpRequest {
    private final HttpClient m_httpClient;
    private final HttpUriRequestBase m_request;

    public ApacheHttpRequest(HttpClient httpClient, HttpUriRequestBase request) {
        this.m_httpClient = httpClient;
        this.m_request = request;
    }

    public void addHeader(String name, String value) throws IOException {
        this.m_request.addHeader(name, (Object)value);
    }

    public void setTimeout(int connectTimeout, int readTimeout) throws IOException {
        super.setTimeout(connectTimeout, readTimeout);
        RequestConfig config = this.m_request.getConfig();
        RequestConfig.Builder configBuilder = config != null ? RequestConfig.copy((RequestConfig)config) : RequestConfig.custom();
        configBuilder.setConnectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS);
        configBuilder.setResponseTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        this.m_request.setConfig(configBuilder.build());
    }

    public LowLevelHttpResponse execute() throws IOException {
        final StreamingContent streamingContent = this.getStreamingContent();
        if (streamingContent != null) {
            AbstractHttpEntity entity = new AbstractHttpEntity(this.getContentType(), this.getContentEncoding()){

                public void close() {
                }

                public void writeTo(OutputStream outstream) throws IOException {
                    streamingContent.writeTo(outstream);
                    outstream.flush();
                }

                public boolean isStreaming() {
                    return true;
                }

                public boolean isRepeatable() {
                    if (streamingContent instanceof HttpContent) {
                        return ((HttpContent)streamingContent).retrySupported();
                    }
                    return false;
                }

                public long getContentLength() {
                    return ApacheHttpRequest.this.getContentLength();
                }

                public InputStream getContent() {
                    throw new UnsupportedOperationException("Streaming entity cannot be represented as an input stream.");
                }
            };
            this.m_request.setEntity((HttpEntity)entity);
        }
        return this.createResponseInternal();
    }

    protected ApacheHttpResponse createResponseInternal() throws IOException {
        try {
            return new ApacheHttpResponse(this.m_request, this.m_httpClient.executeOpen(RoutingSupport.determineHost((HttpRequest)this.m_request), (ClassicHttpRequest)this.m_request, null));
        }
        catch (HttpException e) {
            throw new IOException("Unable to determine host for request", e);
        }
    }
}

