/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.retry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpRequest;

public class OneTimeRepeatableRequestEntityProxy
implements HttpEntity {
    private final HttpEntity m_original;
    private boolean m_consumed;

    public static void installRetry(HttpRequest request) {
        HttpEntity entity;
        if (request instanceof HttpEntityContainer && (entity = ((HttpEntityContainer)request).getEntity()) != null && !(entity instanceof OneTimeRepeatableRequestEntityProxy)) {
            ((HttpEntityContainer)request).setEntity((HttpEntity)new OneTimeRepeatableRequestEntityProxy(entity));
        }
    }

    public OneTimeRepeatableRequestEntityProxy(HttpEntity original) {
        this.m_original = original;
    }

    public HttpEntity getOriginal() {
        return this.m_original;
    }

    public boolean isRepeatable() {
        return !this.m_consumed;
    }

    public boolean isChunked() {
        return this.m_original.isChunked();
    }

    public Set<String> getTrailerNames() {
        return this.m_original.getTrailerNames();
    }

    public long getContentLength() {
        return this.m_original.getContentLength();
    }

    public String getContentType() {
        return this.m_original.getContentType();
    }

    public String getContentEncoding() {
        return this.m_original.getContentEncoding();
    }

    public InputStream getContent() throws IOException {
        return this.m_original.getContent();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        this.m_consumed = true;
        this.m_original.writeTo(outstream);
    }

    public boolean isStreaming() {
        return this.m_original.isStreaming();
    }

    public Supplier<List<? extends Header>> getTrailers() {
        return this.m_original.getTrailers();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.m_original + '}';
    }

    public void close() throws IOException {
        this.m_original.close();
    }
}

