/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.retry;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.eclipse.scout.rt.shared.http.retry.OneTimeRepeatableRequestEntityProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHttpRequestRetryStrategy
extends DefaultHttpRequestRetryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CustomHttpRequestRetryStrategy.class);
    public static final String RETRY_ENABLER_EXEC_CHAIN_NAME = OneTimeRetryPrepareExecChainHandler.class.getSimpleName();
    private final Set<Class<? extends IOException>> m_nonRetriableClasses;
    private final boolean m_retryOnNoHttpResponseException;
    private final boolean m_retryOnSocketExceptionByConnectionReset;
    private final int m_maxRetries;

    public CustomHttpRequestRetryStrategy(int maxRetries, boolean retryOnNoHttpResponseException, boolean retryOnSocketExceptionByConnectionReset) {
        this(maxRetries, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, ConnectionClosedException.class, SSLException.class), retryOnNoHttpResponseException, retryOnSocketExceptionByConnectionReset, Arrays.asList(429, 503));
    }

    protected CustomHttpRequestRetryStrategy(int maxRetries, Collection<Class<? extends IOException>> clazzes, boolean retryOnNoHttpResponseException, boolean retryOnSocketExceptionByConnectionReset, List<Integer> codes) {
        super(maxRetries, TimeValue.ofSeconds((long)1L), clazzes, codes);
        this.m_nonRetriableClasses = new HashSet<Class<? extends IOException>>(clazzes);
        this.m_retryOnNoHttpResponseException = retryOnNoHttpResponseException;
        this.m_retryOnSocketExceptionByConnectionReset = retryOnSocketExceptionByConnectionReset;
        this.m_maxRetries = maxRetries;
    }

    public void enable(HttpAsyncClientBuilder builder) {
        builder.setRetryStrategy((HttpRequestRetryStrategy)this);
    }

    public void enable(HttpClientBuilder builder) {
        builder.addExecInterceptorAfter(ChainElement.RETRY.name(), RETRY_ENABLER_EXEC_CHAIN_NAME, (ExecChainHandler)new OneTimeRetryPrepareExecChainHandler());
        builder.setRetryStrategy((HttpRequestRetryStrategy)this);
    }

    public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
        Args.notNull((Object)request, (String)"request");
        Args.notNull((Object)exception, (String)"exception");
        if (execCount > this.m_maxRetries) {
            return false;
        }
        if (this.m_nonRetriableClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.m_nonRetriableClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        if (request instanceof CancellableDependency && ((CancellableDependency)request).isCancelled()) {
            return false;
        }
        return this.handleAsIdempotent(request) || this.detectStaleSocketChannel(exception);
    }

    public boolean detectStaleSocketChannel(IOException exception) {
        if (this.checkRetryNoHttpResponseException(exception)) {
            String message = "detected a 'NoHttpResponseException', assuming a stale socket channel; retry non-idempotent request";
            if (Thread.currentThread().isInterrupted()) {
                LOG.debug(message);
            } else {
                LOG.warn(message);
            }
            return true;
        }
        if (this.checkRetrySocketException(exception)) {
            String message = "detected a 'SocketException: Connection reset', assuming a stale socket channel; retry non-idempotent request";
            if (Thread.currentThread().isInterrupted()) {
                LOG.debug(message);
            } else {
                LOG.warn(message);
            }
            return true;
        }
        return false;
    }

    protected boolean checkRetryNoHttpResponseException(IOException exception) {
        return this.m_retryOnNoHttpResponseException && exception instanceof NoHttpResponseException;
    }

    protected boolean checkRetrySocketException(IOException exception) {
        return this.m_retryOnSocketExceptionByConnectionReset && exception instanceof SocketException && "Connection reset".equals(exception.getMessage());
    }

    public class OneTimeRetryPrepareExecChainHandler
    implements ExecChainHandler {
        public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
            try {
                return chain.proceed(request, scope);
            }
            catch (IOException e) {
                if (CustomHttpRequestRetryStrategy.this.checkRetryNoHttpResponseException(e) || CustomHttpRequestRetryStrategy.this.checkRetrySocketException(e)) {
                    LOG.debug("Installing {} to support retry of non-idempotent request", OneTimeRepeatableRequestEntityProxy.class, (Object)e);
                    OneTimeRepeatableRequestEntityProxy.installRetry((HttpRequest)request);
                }
                throw e;
            }
        }
    }
}

