/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.config.AbstractStringListConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.shared.http.proxy.ProxyConfigurationProperty;
import org.eclipse.scout.rt.shared.http.proxy.ProxyIgnoreProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class ConfigurableProxySelector
extends ProxySelector {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableProxySelector.class);
    private boolean m_useSystemDefaultProxySelectorAsFallback = true;
    private ProxySelector m_fallbackProxySelector;
    private final Map<Pattern, Proxy> m_proxyMap;
    private final List<Pattern> m_proxyIgnoreList;

    public ConfigurableProxySelector() {
        this(ProxyConfigurationProperty.class, ProxyIgnoreProperty.class);
    }

    public ConfigurableProxySelector(Class<? extends AbstractStringListConfigProperty> proxyProperty, Class<? extends AbstractStringListConfigProperty> ignoreProxyProperty) {
        List proxyMap = (List)CONFIG.getPropertyValue(proxyProperty);
        this.m_proxyMap = new HashMap<Pattern, Proxy>();
        if (proxyMap != null) {
            for (String proxyConfiguration : proxyMap) {
                Pattern pattern = Pattern.compile(proxyConfiguration.substring(0, proxyConfiguration.lastIndexOf(61)), 2);
                String proxyAddress = proxyConfiguration.substring(proxyConfiguration.lastIndexOf(61) + 1);
                String hostname = proxyAddress.substring(0, proxyAddress.lastIndexOf(58));
                int port = Integer.parseInt(proxyAddress.substring(proxyAddress.lastIndexOf(58) + 1));
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port));
                this.m_proxyMap.put(pattern, proxy);
            }
        }
        LOG.trace("Proxy configuration: {}", this.m_proxyMap);
        List proxyIgnoreList = (List)CONFIG.getPropertyValue(ignoreProxyProperty);
        this.m_proxyIgnoreList = new ArrayList<Pattern>();
        if (proxyIgnoreList != null) {
            for (String ignoreProxy : proxyIgnoreList) {
                this.m_proxyIgnoreList.add(Pattern.compile(ignoreProxy, 2));
            }
        }
        LOG.trace("Proxy ignore list: {}", this.m_proxyIgnoreList);
    }

    public boolean isUseSystemDefaultProxySelectorAsFallback() {
        return this.m_useSystemDefaultProxySelectorAsFallback;
    }

    public void setUseSystemDefaultProxySelectorAsFallback(boolean useSystemDefaultProxySelectorAsFallback) {
        this.m_useSystemDefaultProxySelectorAsFallback = useSystemDefaultProxySelectorAsFallback;
    }

    public ProxySelector getFallbackProxySelector() {
        return this.m_fallbackProxySelector;
    }

    public void setFallbackProxySelector(ProxySelector fallbackProxySelector) {
        this.m_fallbackProxySelector = fallbackProxySelector;
    }

    public Map<Pattern, Proxy> getProxyMap() {
        return this.m_proxyMap;
    }

    @Override
    public List<Proxy> select(URI uri) {
        List<Proxy> proxyList;
        ProxySelector fallbackProxySelector;
        LOG.trace("Selecting proxy for {}.", (Object)uri);
        if (!this.m_proxyIgnoreList.isEmpty()) {
            for (Pattern ignorePattern : this.m_proxyIgnoreList) {
                if (!ignorePattern.matcher(uri.toString()).matches()) continue;
                LOG.trace("Using no proxy for {} specified by proxy ignore list.", (Object)uri);
                return Collections.singletonList(Proxy.NO_PROXY);
            }
        }
        if (!this.m_proxyMap.isEmpty()) {
            ArrayList<Proxy> proxyList2 = new ArrayList<Proxy>();
            for (Map.Entry<Pattern, Proxy> entry : this.m_proxyMap.entrySet()) {
                if (!entry.getKey().matcher(uri.toString()).matches()) continue;
                proxyList2.add(entry.getValue());
            }
            if (!proxyList2.isEmpty()) {
                LOG.trace("Using {} for {} (configured by properties).", proxyList2, (Object)uri);
                return proxyList2;
            }
        }
        if ((fallbackProxySelector = this.getFallbackProxySelector()) != null && (proxyList = fallbackProxySelector.select(uri)) != null && !proxyList.isEmpty()) {
            LOG.trace("Using {} for {} (configured by fallback proxy selector).", proxyList, (Object)uri);
            return proxyList;
        }
        if (this.isUseSystemDefaultProxySelectorAsFallback() && (fallbackProxySelector = ProxySelector.getDefault()) != null && fallbackProxySelector != this && (proxyList = fallbackProxySelector.select(uri)) != null && !proxyList.isEmpty()) {
            LOG.trace("Using {} for {} (configured by system default proxy selector).", proxyList, (Object)uri);
            return proxyList;
        }
        LOG.trace("No proxy found for {} using a direct connection.", (Object)uri);
        return Collections.singletonList(Proxy.NO_PROXY);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        LOG.error("Connection to {} using {} as proxy failed.", new Object[]{uri, sa, ioe});
    }

    public static class ProxySelectorInstaller
    implements IPlatformListener {
        private static final Logger LOG = LoggerFactory.getLogger(ProxySelectorInstaller.class);

        public void stateChanged(PlatformEvent event) {
            if (event.getState() == IPlatform.State.BeanManagerPrepared) {
                ProxySelector.setDefault(this.createProxySelector());
                LOG.trace("Installed default proxy selector");
            }
        }

        protected ConfigurableProxySelector createProxySelector() {
            return (ConfigurableProxySelector)BEANS.get(ConfigurableProxySelector.class);
        }
    }
}

