/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.async;

import java.util.function.BiConsumer;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.shared.http.async.AbstractAsyncHttpClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class H2AsyncHttpClientManager
extends AbstractAsyncHttpClientManager<H2AsyncClientBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(H2AsyncHttpClientManager.class);

    @Override
    protected H2AsyncClientBuilder createBuilder() {
        return HttpAsyncClients.customHttp2();
    }

    @Override
    protected void interceptCreateClient(H2AsyncClientBuilder builder) {
        builder.useSystemProperties();
        builder.addExecInterceptorFirst(AbstractAsyncHttpClientManager.AsyncHttpInvocationHandler.class.getSimpleName(), (request, entityProducer, scope, chain, asyncExecCallback) -> chain.proceed(request, LOG.isDebugEnabled() ? this.createAsyncInvocationHandler(AsyncEntityProducer.class, entityProducer) : entityProducer, scope, LOG.isDebugEnabled() ? this.createAsyncInvocationHandler(AsyncExecCallback.class, asyncExecCallback) : asyncExecCallback));
    }

    @Override
    protected BiConsumer<H2AsyncClientBuilder, CookieStore> getInstallCookieStoreBiConsumer() {
        return (builder, cookieStore) -> {
            H2AsyncClientBuilder h2AsyncClientBuilder = builder.setDefaultCookieStore(cookieStore);
        };
    }

    @Override
    protected CloseableHttpAsyncClient createClient(H2AsyncClientBuilder builder) {
        return builder.build();
    }
}

