/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.async;

import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.eclipse.scout.rt.platform.config.AbstractIntegerConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.shared.http.async.DefaultAsyncHttpClientManager;

public class ForceHttp2DefaultAsyncHttpClientManager
extends DefaultAsyncHttpClientManager {
    @Override
    public String getName() {
        return "scout.transport.async.forceHttp2";
    }

    @Override
    protected void interceptCreateConnectionManager(PoolingAsyncClientConnectionManagerBuilder builder) {
        Integer defaultMaxPerRoute;
        builder.setDefaultTlsConfig(TlsConfig.custom().setVersionPolicy(HttpVersionPolicy.FORCE_HTTP_2).build());
        Integer maxTotal = (Integer)CONFIG.getPropertyValue(AsyncForceHttp2MaxConnectionsTotalProperty.class);
        if (maxTotal != null && maxTotal > 0) {
            builder.setMaxConnTotal(maxTotal.intValue());
        }
        if ((defaultMaxPerRoute = (Integer)CONFIG.getPropertyValue(AsyncForceHttp2MaxConnectionsPerRouteProperty.class)) > 0) {
            builder.setMaxConnPerRoute(defaultMaxPerRoute.intValue());
        }
    }

    public static class AsyncForceHttp2MaxConnectionsPerRouteProperty
    extends AbstractIntegerConfigProperty {
        public Integer getDefaultValue() {
            return 2048;
        }

        public String getKey() {
            return "scout.http.async.forceHttp2.maxConnectionsPerRoute";
        }

        public String description() {
            return String.format("Specifies the default maximum connections per route property for the default async force-http2 HTTP client.\nDefault value is %d.", this.getDefaultValue());
        }
    }

    public static class AsyncForceHttp2MaxConnectionsTotalProperty
    extends AbstractIntegerConfigProperty {
        public Integer getDefaultValue() {
            return 2048;
        }

        public String getKey() {
            return "scout.http.async.forceHttp2.maxConnectionsTotal";
        }

        public String description() {
            return String.format("Specifies the default total maximum connections property for the default async force-http2 HTTP client.\nThe default value is %d.", this.getDefaultValue());
        }
    }
}

