/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.async;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.util.TimeValue;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.platform.util.NumberUtility;
import org.eclipse.scout.rt.shared.http.HttpClientMetricsHelper;
import org.eclipse.scout.rt.shared.http.HttpConfigurationProperties;
import org.eclipse.scout.rt.shared.http.async.AbstractAsyncHttpClientManager;
import org.eclipse.scout.rt.shared.http.proxy.ConfigurableProxySelector;
import org.eclipse.scout.rt.shared.http.retry.CustomHttpRequestRetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncHttpClientManager
extends AbstractAsyncHttpClientManager<HttpAsyncClientBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAsyncHttpClientManager.class);

    protected String getName() {
        return "scout.transport.async.default";
    }

    @Override
    protected HttpAsyncClientBuilder createBuilder() {
        return HttpAsyncClients.custom();
    }

    @Override
    protected void interceptCreateClient(HttpAsyncClientBuilder builder) {
        this.installConfigurableProxySelector(builder);
        this.setConnectionKeepAliveAndRetrySettings(builder);
        this.setConnectionEvictionSettings(builder);
        builder.setConnectionManager((AsyncClientConnectionManager)this.createConnectionManager());
        builder.addExecInterceptorFirst(AbstractAsyncHttpClientManager.AsyncHttpInvocationHandler.class.getSimpleName(), (request, entityProducer, scope, chain, asyncExecCallback) -> chain.proceed(request, LOG.isDebugEnabled() ? this.createAsyncInvocationHandler(AsyncEntityProducer.class, entityProducer) : entityProducer, scope, LOG.isDebugEnabled() ? this.createAsyncInvocationHandler(AsyncExecCallback.class, asyncExecCallback) : asyncExecCallback));
    }

    protected void installConfigurableProxySelector(HttpAsyncClientBuilder builder) {
        builder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner((ProxySelector)BEANS.get(ConfigurableProxySelector.class)));
    }

    @Override
    protected BiConsumer<HttpAsyncClientBuilder, CookieStore> getInstallCookieStoreBiConsumer() {
        return (builder, cookieStore) -> {
            HttpAsyncClientBuilder httpAsyncClientBuilder = builder.setDefaultCookieStore(cookieStore);
        };
    }

    protected void setConnectionKeepAliveAndRetrySettings(HttpAsyncClientBuilder builder) {
        this.addConnectionKeepAliveSettings(builder);
        this.addRetrySettings(builder);
        this.addRedirectSettings(builder);
    }

    protected void setConnectionEvictionSettings(HttpAsyncClientBuilder builder) {
        int evictIdleConnectionsTimeout = NumberUtility.nvl((Integer)((Integer)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportEvictIdleConnectionsTimeoutProperty.class)), (int)0);
        if (evictIdleConnectionsTimeout > 0) {
            builder.evictIdleConnections(TimeValue.of((long)evictIdleConnectionsTimeout, (TimeUnit)TimeUnit.SECONDS));
        }
        if (BooleanUtility.nvl((Boolean)((Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportEvictExpiredConnectionsProperty.class)))) {
            builder.evictExpiredConnections();
        }
    }

    protected void addConnectionKeepAliveSettings(HttpAsyncClientBuilder builder) {
        boolean keepAliveProp = (Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportKeepAliveProperty.class);
        if (keepAliveProp) {
            builder.setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE);
        } else {
            builder.setConnectionReuseStrategy((request, response, context) -> false);
        }
    }

    protected void addRetrySettings(HttpAsyncClientBuilder builder) {
        boolean retryOnNoHttpResponseException = (Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportRetryOnNoHttpResponseExceptionProperty.class);
        boolean retryOnSocketExceptionByConnectionReset = (Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportRetryOnSocketExceptionByConnectionResetProperty.class);
        if (retryOnNoHttpResponseException || retryOnSocketExceptionByConnectionReset) {
            CustomHttpRequestRetryStrategy retryStrategy = new CustomHttpRequestRetryStrategy(1, retryOnNoHttpResponseException, retryOnSocketExceptionByConnectionReset);
            retryStrategy.enable(builder);
        } else {
            builder.setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy());
        }
    }

    protected void addRedirectSettings(HttpAsyncClientBuilder builder) {
        builder.setRedirectStrategy((RedirectStrategy)DefaultRedirectStrategy.INSTANCE);
    }

    protected PoolingAsyncClientConnectionManager createConnectionManager() {
        Integer defaultMaxPerRoute;
        PoolingAsyncClientConnectionManagerBuilder builder = PoolingAsyncClientConnectionManagerBuilder.create().useSystemProperties();
        builder.setDefaultConnectionConfig(ConnectionConfig.custom().setTimeToLive((long)((Integer)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportConnectionTimeToLiveProperty.class)).intValue(), TimeUnit.MILLISECONDS).setValidateAfterInactivity(1L, TimeUnit.MILLISECONDS).build());
        Integer maxTotal = (Integer)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportMaxConnectionsTotalProperty.class);
        if (maxTotal != null && maxTotal > 0) {
            builder.setMaxConnTotal(maxTotal.intValue());
        }
        if ((defaultMaxPerRoute = (Integer)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportMaxConnectionsPerRouteProperty.class)) > 0) {
            builder.setMaxConnPerRoute(defaultMaxPerRoute.intValue());
        }
        this.interceptCreateConnectionManager(builder);
        PoolingAsyncClientConnectionManager connectionManager = builder.build();
        this.initMetrics(connectionManager);
        return connectionManager;
    }

    protected void initMetrics(PoolingAsyncClientConnectionManager connectionManager) {
        Meter meter = GlobalOpenTelemetry.get().getMeter(this.getClass().getName());
        ((HttpClientMetricsHelper)BEANS.get(HttpClientMetricsHelper.class)).initMetrics(meter, this.getName(), () -> ((PoolingAsyncClientConnectionManager)connectionManager).getTotalStats());
    }

    protected void interceptCreateConnectionManager(PoolingAsyncClientConnectionManagerBuilder builder) {
    }

    @Override
    protected CloseableHttpAsyncClient createClient(HttpAsyncClientBuilder builder) {
        return builder.build();
    }
}

