/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.async;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.BiConsumer;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.shared.http.ApacheMultiSessionCookieStore;

@ApplicationScoped
public abstract class AbstractAsyncHttpClientManager<BUILDER>
implements IPlatformListener {
    protected volatile boolean m_active = true;
    protected volatile boolean m_initialized = false;
    protected volatile CloseableHttpAsyncClient m_client;
    protected LazyValue<ApacheMultiSessionCookieStore> m_cookieStore = new LazyValue(ApacheMultiSessionCookieStore.class);

    public CloseableHttpAsyncClient getClient() {
        this.init();
        return this.m_client;
    }

    public ApacheMultiSessionCookieStore getCookieStore() {
        return (ApacheMultiSessionCookieStore)this.m_cookieStore.get();
    }

    protected abstract BiConsumer<BUILDER, CookieStore> getInstallCookieStoreBiConsumer();

    protected void installMultiSessionCookieStore(BUILDER builder) {
        BiConsumer<BUILDER, CookieStore> installCookieStoreBiConsumer = this.getInstallCookieStoreBiConsumer();
        if (installCookieStoreBiConsumer == null) {
            return;
        }
        ApacheMultiSessionCookieStore cookieStore = this.getCookieStore();
        if (cookieStore == null) {
            return;
        }
        installCookieStoreBiConsumer.accept(builder, cookieStore);
    }

    protected void init() {
        if (!this.m_initialized) {
            this.initSynchronized();
        }
    }

    protected synchronized void initSynchronized() {
        if (this.m_initialized || !this.m_active) {
            return;
        }
        BUILDER builder = this.createBuilder();
        this.installMultiSessionCookieStore(builder);
        this.interceptCreateClient(builder);
        this.m_client = this.createClient(builder);
        this.m_client.start();
        this.m_initialized = true;
    }

    protected abstract BUILDER createBuilder();

    protected void interceptCreateClient(BUILDER builder) {
    }

    protected abstract CloseableHttpAsyncClient createClient(BUILDER var1);

    public void stateChanged(PlatformEvent event) {
        if (event.getState() == IPlatform.State.PlatformStopping && this.m_client != null) {
            this.removeClient();
        }
    }

    protected synchronized void removeClient() {
        if (this.m_client == null) {
            return;
        }
        try {
            try {
                this.m_client.close();
            }
            catch (IOException e) {
                throw new ProcessingException("Error during {} shut down.", new Object[]{this.m_client, e});
            }
        }
        finally {
            this.m_active = false;
            this.m_client = null;
            this.m_initialized = false;
        }
    }

    protected <T> T createAsyncInvocationHandler(Class<T> clazz, T actualObject) {
        if (actualObject == null) {
            return null;
        }
        Object proxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new AsyncHttpInvocationHandler<T>(actualObject));
        return (T)proxy;
    }

    public static class AsyncHttpInvocationHandler<T>
    implements InvocationHandler {
        private final RunContext m_runContext = RunContexts.copyCurrent((boolean)true).withTransactionScope(TransactionScope.REQUIRES_NEW);
        private final T m_actualObject;

        public AsyncHttpInvocationHandler(T actualObject) {
            this.m_actualObject = actualObject;
        }

        public RunContext getRunContext() {
            return this.m_runContext;
        }

        public T getActualObject() {
            return this.m_actualObject;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.getRunContext().call(() -> method.invoke(this.getActualObject(), args));
        }
    }
}

