/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http;

import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.config.AbstractBooleanConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractIntegerConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractPositiveIntegerConfigProperty;

public final class HttpConfigurationProperties {
    private HttpConfigurationProperties() {
    }

    public static class ApacheHttpTransportConnectionTimeToLiveProperty
    extends AbstractIntegerConfigProperty {
        public Integer getDefaultValue() {
            return 3600000;
        }

        public String description() {
            return "Specifies the maximum lifetime in milliseconds for kept alive connections of the Apache HTTP client. The default value is 1 hour.";
        }

        public String getKey() {
            return "scout.http.connectionTtl";
        }
    }

    public static class ApacheHttpTransportEvictExpiredConnectionsProperty
    extends AbstractBooleanConfigProperty {
        public Boolean getDefaultValue() {
            return true;
        }

        public String description() {
            return "Enable eviction of expired connections.\nThe default value is enabled (= true)";
        }

        public String getKey() {
            return "scout.http.evictExpiredConnections";
        }
    }

    public static class ApacheHttpTransportEvictIdleConnectionsTimeoutProperty
    extends AbstractPositiveIntegerConfigProperty {
        public Integer getDefaultValue() {
            return (int)TimeUnit.MINUTES.toSeconds(1L);
        }

        public String description() {
            return "Enable eviction of idle connections with the specified number in seconds (use zero to disable).\nThe default value is 1 minute";
        }

        public String getKey() {
            return "scout.http.evictIdleConnectionsTimeout";
        }
    }

    public static class ApacheHttpTransportKeepAliveProperty
    extends AbstractBooleanConfigProperty {
        public static final String HTTP_KEEP_ALIVE = "http.keepAlive";

        public Boolean getDefaultValue() {
            String prop = System.getProperty(HTTP_KEEP_ALIVE);
            return prop != null ? Boolean.valueOf(prop) : Boolean.TRUE;
        }

        public String description() {
            return String.format("Enable/disable HTTP keep-alive connections.\nThe default value is defined by the system property '%s' or true if the system property is undefined.", HTTP_KEEP_ALIVE);
        }

        public String getKey() {
            return "scout.http.keepAlive";
        }
    }

    public static class ApacheHttpTransportMaxConnectionsPerRouteProperty
    extends AbstractIntegerConfigProperty {
        public Integer getDefaultValue() {
            return 32;
        }

        public String description() {
            return "Configuration property to define the default maximum connections per route of the Apache HTTP client. The default value is 32.";
        }

        public String getKey() {
            return "scout.http.maxConnectionsPerRoute";
        }
    }

    public static class ApacheHttpTransportMaxConnectionsTotalProperty
    extends AbstractIntegerConfigProperty {
        public Integer getDefaultValue() {
            return 128;
        }

        public String description() {
            return "Specifies the total maximum connections of the Apache HTTP client. The default value is 128.";
        }

        public String getKey() {
            return "scout.http.maxConnectionsTotal";
        }
    }

    public static class ApacheHttpTransportRetryOnNoHttpResponseExceptionProperty
    extends AbstractBooleanConfigProperty {
        public Boolean getDefaultValue() {
            return true;
        }

        public String description() {
            return "Enable retry of request (includes non-idempotent requests) on NoHttpResponseException\nAssuming that the cause of the exception was most probably a stale socket channel on the server side.\nThe default value is true";
        }

        public String getKey() {
            return "scout.http.retryOnNoHttpResponseException";
        }
    }

    public static class ApacheHttpTransportRetryOnSocketExceptionByConnectionResetProperty
    extends AbstractBooleanConfigProperty {
        public Boolean getDefaultValue() {
            return true;
        }

        public String description() {
            return "Enable retry of request (includes non-idempotent requests) on {@link SocketException} with message 'Connection reset'\nAssuming that the cause of the exception was most probably a stale socket channel on the server side.\nThe default value is true";
        }

        public String getKey() {
            return "scout.http.retryOnSocketExceptionByConnectionReset";
        }
    }
}

