/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.function.Supplier;
import org.apache.hc.core5.pool.PoolStats;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HttpClientMetricsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientMetricsHelper.class);
    protected static final AttributeKey<String> HTTP_CLIENT_NAME = AttributeKey.stringKey((String)"http.client.name");
    protected static final AttributeKey<String> HTTP_CONNECTION_STATE = AttributeKey.stringKey((String)"state");

    public void initMetrics(Meter meter, String httpClientName, Supplier<PoolStats> poolStatsSupplier) {
        Assertions.assertNotNullOrEmpty((String)httpClientName, (String)"HTTP client name not specified. A Java process can use multiple HTTP connection providers (pools). To distinguish them in such situations, a unique HTTP client name is required.", (Object[])new Object[0]);
        LOG.info("Init HTTP client connection pool '{}'", (Object)httpClientName);
        ObservableLongMeasurement connectionsUsage = meter.upDownCounterBuilder("http.client.open_connections").setDescription("Number of outbound HTTP connections that are currently active or idle on the client.").setUnit("{connection}").buildObserver();
        ObservableLongMeasurement maxConnections = meter.upDownCounterBuilder("http.client.connections.max").setDescription("The maximum number of allowed outbound HTTP connections.").setUnit("{connection}").buildObserver();
        Attributes defaultAttributes = Attributes.of(HTTP_CLIENT_NAME, (Object)httpClientName);
        Attributes activeConnectionsAttributes = defaultAttributes.toBuilder().put(HTTP_CONNECTION_STATE, (Object)"active").build();
        Attributes idleConnectionsAttributes = defaultAttributes.toBuilder().put(HTTP_CONNECTION_STATE, (Object)"idle").build();
        meter.batchCallback(() -> {
            PoolStats stats = (PoolStats)poolStatsSupplier.get();
            connectionsUsage.record((long)stats.getLeased(), activeConnectionsAttributes);
            connectionsUsage.record((long)stats.getAvailable(), idleConnectionsAttributes);
            maxConnections.record((long)stats.getMax(), defaultAttributes);
        }, (ObservableMeasurement)connectionsUsage, new ObservableMeasurement[]{maxConnections});
    }
}

