/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http;

import com.google.api.client.http.HttpTransport;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.platform.util.NumberUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.http.ApacheMultiSessionCookieStore;
import org.eclipse.scout.rt.shared.http.HttpClientMetricsHelper;
import org.eclipse.scout.rt.shared.http.HttpConfigurationProperties;
import org.eclipse.scout.rt.shared.http.IHttpTransportBuilder;
import org.eclipse.scout.rt.shared.http.IHttpTransportFactory;
import org.eclipse.scout.rt.shared.http.IHttpTransportManager;
import org.eclipse.scout.rt.shared.http.proxy.ConfigurableProxySelector;
import org.eclipse.scout.rt.shared.http.retry.CustomHttpRequestRetryStrategy;
import org.eclipse.scout.rt.shared.http.transport.ApacheHttpTransport;

public class ApacheHttpTransportFactory
implements IHttpTransportFactory {
    @Override
    public HttpTransport newHttpTransport(IHttpTransportManager manager) {
        HttpClientBuilder builder = HttpClients.custom();
        this.installConfigurableProxySelector(builder);
        this.installMultiSessionCookieStore(builder);
        this.setConnectionKeepAliveAndRetrySettings(builder);
        this.setConnectionEvictionSettings(builder);
        HttpClientConnectionManager cm = this.createHttpClientConnectionManager(manager);
        if (cm != null) {
            builder.setConnectionManager(cm);
        }
        this.interceptNewHttpTransport(builder, manager);
        manager.interceptNewHttpTransport(new ApacheHttpTransportBuilder(builder, cm));
        return new ApacheHttpTransport((HttpClient)builder.build());
    }

    protected void setConnectionKeepAliveAndRetrySettings(HttpClientBuilder builder) {
        this.addConnectionKeepAliveSettings(builder);
        this.addRetrySettings(builder);
        this.addRedirectSettings(builder);
    }

    protected void setConnectionEvictionSettings(HttpClientBuilder builder) {
        int evictIdleConnectionsTimeout = NumberUtility.nvl((Integer)((Integer)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportEvictIdleConnectionsTimeoutProperty.class)), (int)0);
        if (evictIdleConnectionsTimeout > 0) {
            builder.evictIdleConnections(TimeValue.of((long)evictIdleConnectionsTimeout, (TimeUnit)TimeUnit.SECONDS));
        }
        if (BooleanUtility.nvl((Boolean)((Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportEvictExpiredConnectionsProperty.class)))) {
            builder.evictExpiredConnections();
        }
    }

    protected void addConnectionKeepAliveSettings(HttpClientBuilder builder) {
        boolean keepAliveProp = (Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportKeepAliveProperty.class);
        if (keepAliveProp) {
            builder.setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE);
        } else {
            builder.setConnectionReuseStrategy((request, response, context) -> false);
        }
    }

    protected void addRetrySettings(HttpClientBuilder builder) {
        boolean retryOnNoHttpResponseException = (Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportRetryOnNoHttpResponseExceptionProperty.class);
        boolean retryOnSocketExceptionByConnectionReset = (Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportRetryOnSocketExceptionByConnectionResetProperty.class);
        if (retryOnNoHttpResponseException || retryOnSocketExceptionByConnectionReset) {
            CustomHttpRequestRetryStrategy retryStrategy = new CustomHttpRequestRetryStrategy(1, retryOnNoHttpResponseException, retryOnSocketExceptionByConnectionReset);
            retryStrategy.enable(builder);
        } else {
            builder.setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy());
        }
    }

    protected void addRedirectSettings(HttpClientBuilder builder) {
        builder.setRedirectStrategy((RedirectStrategy)DefaultRedirectStrategy.INSTANCE);
    }

    protected HttpClientConnectionManager createHttpClientConnectionManager(IHttpTransportManager manager) {
        Integer defaultMaxPerRoute;
        PoolingHttpClientConnectionManagerBuilder builder = PoolingHttpClientConnectionManagerBuilder.create();
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.createSSLConnectionSocketFactory());
        builder.setDefaultConnectionConfig(ConnectionConfig.custom().setTimeToLive((long)((Integer)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportConnectionTimeToLiveProperty.class)).intValue(), TimeUnit.MILLISECONDS).setValidateAfterInactivity(1L, TimeUnit.MILLISECONDS).build());
        Integer maxTotal = (Integer)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportMaxConnectionsTotalProperty.class);
        if (maxTotal != null && maxTotal > 0) {
            builder.setMaxConnTotal(maxTotal.intValue());
        }
        if ((defaultMaxPerRoute = (Integer)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportMaxConnectionsPerRouteProperty.class)) > 0) {
            builder.setMaxConnPerRoute(defaultMaxPerRoute.intValue());
        }
        this.interceptNewHttpClientConnectionManager(builder, manager);
        PoolingHttpClientConnectionManager connectionManager = builder.build();
        this.initMetrics(manager, connectionManager);
        return connectionManager;
    }

    protected void initMetrics(IHttpTransportManager manager, PoolingHttpClientConnectionManager connectionManager) {
        Meter meter = GlobalOpenTelemetry.get().getMeter(this.getClass().getName());
        ((HttpClientMetricsHelper)BEANS.get(HttpClientMetricsHelper.class)).initMetrics(meter, manager.getName(), () -> ((PoolingHttpClientConnectionManager)connectionManager).getTotalStats());
    }

    protected SSLConnectionSocketFactory createSSLConnectionSocketFactory() {
        String[] sslProtocols = StringUtility.split((String)System.getProperty("https.protocols"), (String)"\\s*,\\s*");
        String[] sslCipherSuites = StringUtility.split((String)System.getProperty("https.cipherSuites"), (String)"\\s*,\\s*");
        return new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), sslProtocols != null && sslProtocols.length > 0 ? sslProtocols : null, sslCipherSuites != null && sslCipherSuites.length > 0 ? sslCipherSuites : null, HttpsSupport.getDefaultHostnameVerifier());
    }

    protected PlainConnectionSocketFactory createPlainSocketFactory() {
        return PlainConnectionSocketFactory.getSocketFactory();
    }

    protected void installConfigurableProxySelector(HttpClientBuilder builder) {
        builder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner((ProxySelector)BEANS.get(ConfigurableProxySelector.class)));
    }

    protected void installMultiSessionCookieStore(HttpClientBuilder builder) {
        builder.setDefaultCookieStore((CookieStore)BEANS.get(ApacheMultiSessionCookieStore.class));
    }

    protected void interceptNewHttpTransport(HttpClientBuilder builder, IHttpTransportManager manager) {
    }

    protected void interceptNewHttpClientConnectionManager(PoolingHttpClientConnectionManagerBuilder builder, IHttpTransportManager manager) {
    }

    public static class ApacheHttpTransportBuilder
    implements IHttpTransportBuilder {
        private final HttpClientBuilder m_builder;
        private final HttpClientConnectionManager m_connectionManager;

        public ApacheHttpTransportBuilder(HttpClientBuilder builder, HttpClientConnectionManager connectionManager) {
            this.m_builder = builder;
            this.m_connectionManager = connectionManager;
        }

        public HttpClientBuilder getBuilder() {
            return this.m_builder;
        }

        public HttpClientConnectionManager getConnectionManager() {
            return this.m_connectionManager;
        }
    }
}

