/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.util.Deque;
import java.util.LinkedList;
import org.eclipse.scout.rt.shared.extension.ExtensionRegistryItem;
import org.eclipse.scout.rt.shared.extension.ExtensionScope;

public class ScopeStack {
    private final Deque<ExtensionScope<ExtensionRegistryItem>> m_contributionScopes = new LinkedList<ExtensionScope<ExtensionRegistryItem>>();
    private final Deque<ExtensionScope<ExtensionRegistryItem>> m_extensionScopes = new LinkedList<ExtensionScope<ExtensionRegistryItem>>();

    public ScopeStack(ExtensionScope<ExtensionRegistryItem> globalContributionScope, ExtensionScope<ExtensionRegistryItem> globalExtensionScope) {
        this.m_contributionScopes.push(globalContributionScope);
        this.m_extensionScopes.push(globalExtensionScope);
    }

    public void pushScope(Class<?> owner) {
        this.pushScope(owner, this.m_contributionScopes);
        this.pushScope(owner, this.m_extensionScopes);
    }

    public void popScope() {
        this.m_contributionScopes.pop();
        this.m_extensionScopes.pop();
    }

    protected void pushScope(Class<?> owner, Deque<ExtensionScope<ExtensionRegistryItem>> scopes) {
        ExtensionScope<ExtensionRegistryItem> subScope = scopes.peek().getSubScope(owner);
        scopes.push(subScope);
    }

    public ExtensionScope<ExtensionRegistryItem> getContributionScope() {
        return this.m_contributionScopes.peek();
    }

    public ExtensionScope<ExtensionRegistryItem> getExtensionScope() {
        return this.m_extensionScopes.peek();
    }

    public boolean isEmpty() {
        return this.m_contributionScopes.size() == 1 && this.m_extensionScopes.size() == 1;
    }
}

