/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import org.eclipse.scout.rt.platform.classid.ClassIdentifier;

public class ScopeItem {
    private final ClassIdentifier m_identifier;
    private final boolean m_topDownStrategy;
    private final int m_index;

    public ScopeItem(ClassIdentifier identifier, boolean topDownStrategy) {
        this(identifier, topDownStrategy ? 0 : identifier.size() - 1, topDownStrategy);
    }

    private ScopeItem(ClassIdentifier identifier, int index, boolean topDownStrategy) {
        this.m_identifier = identifier;
        this.m_index = index;
        this.m_topDownStrategy = topDownStrategy;
    }

    public Class<?> getCurrentSegment() {
        return this.m_identifier.getClasses()[this.m_index];
    }

    public boolean isLastSegment() {
        if (this.m_topDownStrategy) {
            return this.m_index == this.m_identifier.size() - 1;
        }
        return this.m_index == 0;
    }

    public ClassIdentifier getIdentifier() {
        return this.m_identifier;
    }

    public ScopeItem createSubScopeItem() {
        if (this.isLastSegment()) {
            return null;
        }
        if (this.m_topDownStrategy) {
            return new ScopeItem(this.getIdentifier(), this.m_index + 1, true);
        }
        return new ScopeItem(this.getIdentifier(), this.m_index - 1, false);
    }

    public String toString() {
        return "ScopeItem [m_identifier=" + String.valueOf(this.m_identifier) + ", m_index=" + this.m_index + "]";
    }
}

