/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.platform.classid.ClassIdentifier;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.extension.AbstractExtensionRegistryItem;
import org.eclipse.scout.rt.shared.extension.ScopeItem;

public class ExtensionScope<T extends AbstractExtensionRegistryItem> {
    private static final ConcurrentMap<Class<?>, Set<Class<?>>> CLASS_HIERARCHIES = new ConcurrentHashMap(10000);
    private final ExtensionScope<T> m_parentScope;
    private final Map<Class<?>, Set<ScopeItem>> m_scopeItems;
    private final Map<ClassIdentifier, List<T>> m_extensionItems;
    private final ConcurrentMap<Class<?>, ExtensionScope<T>> m_cachedSubScopesByModelClass = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Set<ScopeItem>> m_cachedScopeItemsByModelClass = new ConcurrentHashMap();

    public ExtensionScope(Map<ClassIdentifier, List<T>> extensionItems, boolean topDownStrategy) {
        this.m_extensionItems = extensionItems;
        this.m_scopeItems = this.createGlobalScope(extensionItems.keySet(), topDownStrategy);
        this.m_parentScope = null;
    }

    protected ExtensionScope(Map<Class<?>, Set<ScopeItem>> scopeItems, ExtensionScope<T> parentScope, Map<ClassIdentifier, List<T>> extensionItems) {
        this.m_scopeItems = scopeItems;
        this.m_parentScope = parentScope;
        this.m_extensionItems = extensionItems;
    }

    protected Map<Class<?>, Set<ScopeItem>> createGlobalScope(Collection<ClassIdentifier> classIdentifiers, boolean topDownStrategy) {
        HashMap scopeItems = new HashMap(classIdentifiers.size());
        for (ClassIdentifier identifier : classIdentifiers) {
            ScopeItem item = new ScopeItem(identifier, topDownStrategy);
            scopeItems.computeIfAbsent(item.getCurrentSegment(), k -> new HashSet()).add(item);
        }
        return scopeItems;
    }

    public Set<T> getRegistryItems(Class<?> owner) {
        Set<ScopeItem> scopeItems = this.getScopeItems(owner);
        return this.resolveRegistryItems(scopeItems);
    }

    public ExtensionScope<T> getSubScope(Class<?> ownerType) {
        return this.m_cachedSubScopesByModelClass.computeIfAbsent(ownerType, this::createSubScope);
    }

    protected ExtensionScope<T> createSubScope(Class<?> ownerType) {
        if (ownerType == null) {
            throw new IllegalArgumentException("ownerType must not be null.");
        }
        HashSet<ScopeItem> items = new HashSet<ScopeItem>();
        ExtensionScope<T> curScope = this;
        while (curScope != null) {
            this.collectScopeItems(ownerType, items, curScope.m_scopeItems);
            curScope = curScope.m_parentScope;
        }
        if (CollectionUtility.isEmpty(items)) {
            return this;
        }
        HashMap subScopeItems = new HashMap(items.size());
        for (ScopeItem item : items) {
            this.collectSubScopeItems(item, subScopeItems);
        }
        if (subScopeItems.isEmpty()) {
            return this;
        }
        return new ExtensionScope<T>(subScopeItems, this, this.m_extensionItems);
    }

    public Set<ScopeItem> filterScopeItems(Class<?> modelClass, Iterator<?> parentModelObjectIterator) {
        Set<ScopeItem> scopeItems = this.getScopeItems(modelClass);
        if (CollectionUtility.isEmpty(scopeItems)) {
            return null;
        }
        HashSet<ScopeItem> potentialScopeItems = new HashSet<ScopeItem>(scopeItems);
        HashSet<ScopeItem> filteredScopeItems = new HashSet<ScopeItem>();
        HashMap subScopeItems = new HashMap(potentialScopeItems.size());
        this.collectFilteredAndSubScopeItems(potentialScopeItems, filteredScopeItems, subScopeItems);
        if (parentModelObjectIterator != null && CollectionUtility.hasElements(potentialScopeItems)) {
            while (parentModelObjectIterator.hasNext()) {
                Object parent = parentModelObjectIterator.next();
                if (parent == null) continue;
                potentialScopeItems.clear();
                this.collectScopeItems(parent.getClass(), potentialScopeItems, subScopeItems);
                this.collectFilteredAndSubScopeItems(potentialScopeItems, filteredScopeItems, subScopeItems);
            }
        }
        return filteredScopeItems;
    }

    protected void collectFilteredAndSubScopeItems(Set<ScopeItem> potentialScopeItems, Set<ScopeItem> filteredScopeItems, Map<Class<?>, Set<ScopeItem>> subScopeItems) {
        for (ScopeItem item : potentialScopeItems) {
            if (item.isLastSegment()) {
                filteredScopeItems.add(item);
                continue;
            }
            this.collectSubScopeItems(item, subScopeItems);
        }
    }

    protected void collectSubScopeItems(ScopeItem item, Map<Class<?>, Set<ScopeItem>> subScopeItems) {
        ScopeItem subScopeItem = item.createSubScopeItem();
        if (subScopeItem == null) {
            return;
        }
        subScopeItems.computeIfAbsent(subScopeItem.getCurrentSegment(), k -> new HashSet()).add(subScopeItem);
    }

    protected Set<ScopeItem> getScopeItems(Class<?> owner) {
        return this.m_cachedScopeItemsByModelClass.computeIfAbsent(owner, o -> Set.copyOf(this.computeScopeItems((Class<?>)o)));
    }

    protected Set<ScopeItem> computeScopeItems(Class<?> owner) {
        HashSet<ScopeItem> collector = new HashSet<ScopeItem>();
        if (this.m_parentScope != null) {
            Set<ScopeItem> parentScopeItems = this.m_parentScope.getScopeItems(owner);
            collector.addAll(parentScopeItems);
        }
        this.collectScopeItems(owner, collector, this.m_scopeItems);
        return collector;
    }

    protected void collectScopeItems(Class<?> curClass, Set<ScopeItem> collector, Map<Class<?>, Set<ScopeItem>> scopeItems) {
        this.getClassHierarchy(curClass).stream().map(scopeItems::get).filter(Objects::nonNull).forEach(collector::addAll);
    }

    protected Set<Class<?>> getClassHierarchy(Class<?> c) {
        Set<Class<?>> hPrev;
        if (c == Object.class) {
            return Collections.emptySet();
        }
        Set<Class<?>> h = (Set<Class<?>>)CLASS_HIERARCHIES.get(c);
        if (h == null && (hPrev = CLASS_HIERARCHIES.putIfAbsent(c, h = this.computeHierarchy(c))) != null) {
            h = hPrev;
        }
        return h;
    }

    protected Set<Class<?>> computeHierarchy(Class<?> c) {
        HashSet result = new HashSet();
        result.add(c);
        Class<?> superClass = c.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            result.addAll(this.getClassHierarchy(superClass));
        }
        Class<?>[] classArray = c.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            result.addAll(this.getClassHierarchy(i));
            ++n2;
        }
        return Set.of(result.toArray(new Class[0]));
    }

    public Set<T> resolveRegistryItems(Set<ScopeItem> scopeItems) {
        if (CollectionUtility.isEmpty(scopeItems)) {
            return Collections.emptySet();
        }
        return scopeItems.stream().filter(ScopeItem::isLastSegment).map(ScopeItem::getIdentifier).map(this.m_extensionItems::get).filter(Objects::nonNull).flatMap(Collection::stream).sorted(Comparator.comparingLong(AbstractExtensionRegistryItem::getOrder)).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

