/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.scout.rt.shared.extension.IExtension;

public abstract class AbstractExtensionChain<EXTENSION> {
    private final ListIterator<? extends IExtension<?>> m_iterator;
    private final Class<?> m_filterClass;
    private boolean m_hasExtension;
    private EXTENSION m_currentExtension;

    public AbstractExtensionChain(List<? extends IExtension<?>> extensions, Class<? extends IExtension> filterClass) {
        this.m_filterClass = filterClass;
        this.m_iterator = extensions.listIterator();
    }

    protected boolean hasNext() {
        this.computeNext(true);
        return this.m_hasExtension;
    }

    protected EXTENSION next() {
        this.computeNext(false);
        if (!this.m_hasExtension) {
            throw new NoSuchElementException();
        }
        return this.m_currentExtension;
    }

    private void computeNext(boolean forceRewind) {
        this.m_hasExtension = false;
        int nextCount = 0;
        while (this.m_iterator.hasNext()) {
            IExtension<?> next = this.m_iterator.next();
            ++nextCount;
            if (!this.m_filterClass.isInstance(next)) continue;
            this.m_hasExtension = true;
            IExtension<?> extension = next;
            this.m_currentExtension = extension;
            break;
        }
        if (!this.m_hasExtension || forceRewind) {
            int i = nextCount;
            while (i > 0) {
                this.m_iterator.previous();
                --i;
            }
        }
    }

    protected boolean hasPrevious() {
        this.computePrevious(true);
        return this.m_hasExtension;
    }

    protected EXTENSION previous() {
        this.computePrevious(false);
        if (!this.m_hasExtension) {
            throw new NoSuchElementException();
        }
        return this.m_currentExtension;
    }

    private void computePrevious(boolean forceRewind) {
        this.m_hasExtension = false;
        int previousCount = 0;
        while (this.m_iterator.hasPrevious()) {
            IExtension<?> previous = this.m_iterator.previous();
            ++previousCount;
            if (!this.m_filterClass.isInstance(previous)) continue;
            this.m_hasExtension = true;
            IExtension<?> extension = previous;
            this.m_currentExtension = extension;
            break;
        }
        if (!this.m_hasExtension || forceRewind) {
            int i = previousCount;
            while (i > 0) {
                this.m_iterator.next();
                --i;
            }
        }
    }

    protected void callChain(MethodInvocation<?> methodInvocation) {
        if (this.hasNext()) {
            EXTENSION nextExtension = this.next();
            try {
                try {
                    methodInvocation.callMethod(nextExtension);
                }
                catch (RuntimeException e) {
                    methodInvocation.setException(e);
                    throw e;
                }
                catch (Exception e) {
                    methodInvocation.setException(e);
                    this.previous();
                }
            }
            finally {
                this.previous();
            }
        } else {
            throw new IllegalStateException("No more elements in chain.");
        }
    }

    public abstract class MethodInvocation<RETURN_VALUE> {
        private Exception m_exception;
        private RETURN_VALUE m_returnValue;

        protected abstract void callMethod(EXTENSION var1);

        public void setException(Exception exception) {
            this.m_exception = exception;
        }

        public Exception getException() {
            return this.m_exception;
        }

        protected void setReturnValue(RETURN_VALUE returnValue) {
            this.m_returnValue = returnValue;
        }

        public RETURN_VALUE getReturnValue() {
            return this.m_returnValue;
        }
    }
}

