/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IInternalExtensionRegistry;
import org.eclipse.scout.rt.shared.extension.IllegalExtensionException;

public abstract class AbstractContributionComposite
implements IContributionOwner,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Class<?>, Object> m_contributionsByClass;

    protected AbstractContributionComposite() {
        this(null, true);
    }

    protected AbstractContributionComposite(Object o, boolean useScope) {
        IInternalExtensionRegistry extensionRegistry = (IInternalExtensionRegistry)BEANS.get(IInternalExtensionRegistry.class);
        try {
            if (useScope) {
                extensionRegistry.pushScope(this.getClass());
            }
            this.initContributionsMap(o, extensionRegistry, null);
            this.initConfig();
        }
        finally {
            if (useScope) {
                extensionRegistry.popScope();
            }
        }
    }

    protected void initConfig() {
    }

    private <T> void initContributionsMap(Object o, IInternalExtensionRegistry extensionRegistry, Class<T> type) {
        List<T> contributionsForMe;
        Object owner = this;
        if (o != null) {
            owner = o;
        }
        if (CollectionUtility.hasElements(contributionsForMe = extensionRegistry.createContributionsFor(owner, type))) {
            if (this.m_contributionsByClass == null) {
                this.m_contributionsByClass = new HashMap(contributionsForMe.size(), 1.0f);
            }
            for (T contribution : contributionsForMe) {
                this.m_contributionsByClass.put(contribution.getClass(), contribution);
            }
        }
    }

    public <T> void resetContributionsByClass(Object o, Class<T> type) {
        Assertions.assertNotNull(type, (String)"Contribution type class must be specified", (Object[])new Object[0]);
        if (this.m_contributionsByClass != null) {
            this.m_contributionsByClass.values().removeIf(obj -> type.isAssignableFrom(obj.getClass()));
        }
        IInternalExtensionRegistry extensionRegistry = (IInternalExtensionRegistry)BEANS.get(IInternalExtensionRegistry.class);
        this.initContributionsMap(o, extensionRegistry, type);
    }

    protected Collection<Object> getAllContributionsInternal() {
        if (this.m_contributionsByClass == null) {
            return null;
        }
        return this.m_contributionsByClass.values();
    }

    @Override
    public List<Object> getAllContributions() {
        return CollectionUtility.arrayList(this.getAllContributionsInternal());
    }

    @Override
    public <T> List<T> getContributionsByClass(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Contribution type class must be specified.");
        }
        if (this.m_contributionsByClass == null) {
            return new ArrayList(0);
        }
        return this.m_contributionsByClass.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    @Override
    public <T> T getContribution(Class<T> contribution) {
        T result = this.optContribution(contribution);
        if (result != null) {
            return result;
        }
        throw new IllegalExtensionException("No contribution of type '" + contribution.getName() + "' exists for class '" + this.getClass().getName() + "'.");
    }

    @Override
    public <T> T optContribution(Class<T> contribution) {
        if (contribution == null) {
            throw new IllegalArgumentException("Contribution class must be specified.");
        }
        if (this.m_contributionsByClass == null) {
            return null;
        }
        Object object = this.m_contributionsByClass.get(contribution);
        if (object != null) {
            return contribution.cast(object);
        }
        for (Object o : this.m_contributionsByClass.values()) {
            T result;
            if (!(o instanceof IContributionOwner) || (result = ((IContributionOwner)o).optContribution(contribution)) == null) continue;
            return result;
        }
        return null;
    }
}

