/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.shared.extension.IExtensionRegistrationValidatorService;

public abstract class AbstractContainerValidationService
implements IExtensionRegistrationValidatorService {
    private final Map<Class<?>, Set<Class<?>>> m_possibleContributionsByContainer = new HashMap();
    private final Map<Class<? extends IOrdered>, Set<Class<? extends IOrdered>>> m_possibleMovesByContainer = new HashMap<Class<? extends IOrdered>, Set<Class<? extends IOrdered>>>();

    protected AbstractContainerValidationService() {
    }

    private static <T> void removeFromMap(Class<? extends T> key, Class<? extends T> value, Map<Class<? extends T>, Set<Class<? extends T>>> map) {
        Set<Class<T>> values = map.get(key);
        if (values != null) {
            values.remove(value);
            if (values.isEmpty()) {
                map.remove(key);
            }
        }
    }

    private static <T> void addToMap(Class<? extends T> key, Class<? extends T> value, Map<Class<? extends T>, Set<Class<? extends T>>> map) {
        Set values = map.computeIfAbsent(key, k -> new HashSet());
        values.add(value);
    }

    private static <T> boolean isValid(Class<? extends T> key, Class<? extends T> value, Map<Class<? extends T>, Set<Class<? extends T>>> map) {
        for (Map.Entry<Class<T>, Set<Class<T>>> entry : map.entrySet()) {
            Class<T> curContainer = entry.getKey();
            if (!curContainer.isAssignableFrom(key)) continue;
            Set<Class<T>> values = entry.getValue();
            for (Class<T> cur : values) {
                if (!cur.isAssignableFrom(value)) continue;
                return true;
            }
        }
        return false;
    }

    public void removePossibleContributionForContainer(Class<?> contribution, Class<?> container) {
        AbstractContainerValidationService.removeFromMap(container, contribution, this.m_possibleContributionsByContainer);
    }

    public void addPossibleContributionForContainer(Class<?> contribution, Class<?> container) {
        AbstractContainerValidationService.addToMap(container, contribution, this.m_possibleContributionsByContainer);
    }

    public void addPossibleMoveForContainer(Class<? extends IOrdered> model, Class<? extends IOrdered> container) {
        AbstractContainerValidationService.addToMap(model, container, this.m_possibleMovesByContainer);
    }

    public void removePossibleMoveFForContainer(Class<? extends IOrdered> model, Class<? extends IOrdered> container) {
        AbstractContainerValidationService.removeFromMap(container, model, this.m_possibleMovesByContainer);
    }

    @Override
    public boolean isValidContribution(Class<?> contribution, Class<?> container) {
        return AbstractContainerValidationService.isValid(container, contribution, this.m_possibleContributionsByContainer);
    }

    @Override
    public boolean isValidMove(Class<? extends IOrdered> modelClass, Class<? extends IOrdered> newContainerClass) {
        return AbstractContainerValidationService.isValid(modelClass, newContainerClass, this.m_possibleMovesByContainer);
    }
}

