/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.form.fields.tablefield;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.holders.ITableBeanHolder;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;

public abstract class AbstractTableFieldBeanData
extends AbstractFormFieldData
implements ITableBeanHolder {
    private static final long serialVersionUID = 1L;
    private final List<AbstractTableRowData> m_rowList = new ArrayList<AbstractTableRowData>();

    public int getRowCount() {
        return this.m_rowList.size();
    }

    public AbstractTableRowData[] getRows() {
        return this.m_rowList.toArray((AbstractTableRowData[])Array.newInstance(this.getRowType(), this.m_rowList.size()));
    }

    public void setRows(AbstractTableRowData[] rows) {
        this.m_rowList.clear();
        Class<? extends AbstractTableRowData> rowType = this.getRowType();
        if (rowType == null) {
            throw new IllegalStateException("row type is not initialized");
        }
        AbstractTableRowData[] abstractTableRowDataArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTableRowData row = abstractTableRowDataArray[n2];
            if (row != null) {
                if (!rowType.isInstance(row)) {
                    throw new IllegalArgumentException("wrong row type. Expected [" + rowType.getName() + "], actual: [" + row.getClass().getName() + "]");
                }
                this.m_rowList.add(row);
            }
            ++n2;
        }
        this.setValueSet(true);
    }

    public AbstractTableRowData rowAt(int index) {
        return this.m_rowList.get(index);
    }

    public AbstractTableRowData addRow() {
        return this.addRow(0);
    }

    public AbstractTableRowData addRow(int rowState) {
        AbstractTableRowData row = this.createRow();
        row.setRowState(rowState);
        this.m_rowList.add(row);
        this.setValueSet(true);
        return row;
    }

    public void addRow(AbstractTableRowData rowData) {
        this.m_rowList.add(rowData);
        this.setValueSet(true);
    }

    public abstract AbstractTableRowData createRow();

    public abstract Class<? extends AbstractTableRowData> getRowType();

    public void removeRow(int index) {
        this.m_rowList.remove(index);
        this.setValueSet(true);
    }

    public boolean removeRow(AbstractTableRowData row) {
        if (this.m_rowList.remove(row)) {
            this.setValueSet(true);
            return true;
        }
        return false;
    }

    public void clearRows() {
        this.m_rowList.clear();
        this.setValueSet(true);
    }
}

