/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.colorscheme;

import java.util.stream.Stream;
import org.eclipse.scout.rt.shared.data.colorscheme.IColorScheme;

public enum ColorScheme implements IColorScheme
{
    DEFAULT("default", false),
    DEFAULT_INVERTED("default", true),
    ALTERNATIVE("alternative", false),
    ALTERNATIVE_INVERTED("alternative", true),
    RAINBOW("rainbow", false);

    private final String m_schemeId;
    private final boolean m_inverted;

    private ColorScheme(String schemeId, boolean inverted) {
        this.m_schemeId = schemeId;
        this.m_inverted = inverted;
    }

    @Override
    public String getIdentifier() {
        return this.m_schemeId + (this.m_inverted ? "-inverted" : "");
    }

    public static ColorScheme parse(String identifier) {
        return Stream.of(ColorScheme.values()).filter(colorScheme -> colorScheme.getIdentifier().equals(identifier)).findFirst().orElse(null);
    }

    public ColorScheme invert() {
        switch (this) {
            case DEFAULT: {
                return DEFAULT_INVERTED;
            }
            case DEFAULT_INVERTED: {
                return DEFAULT;
            }
            case ALTERNATIVE: {
                return ALTERNATIVE_INVERTED;
            }
            case ALTERNATIVE_INVERTED: {
                return ALTERNATIVE;
            }
        }
        return this;
    }

    public ColorScheme toggle() {
        switch (this) {
            case DEFAULT: {
                return ALTERNATIVE;
            }
            case DEFAULT_INVERTED: {
                return ALTERNATIVE_INVERTED;
            }
            case ALTERNATIVE: {
                return RAINBOW;
            }
            case ALTERNATIVE_INVERTED: {
                return RAINBOW;
            }
            case RAINBOW: {
                return DEFAULT;
            }
        }
        return this;
    }

    public static interface SchemeIds {
        public static final String SCHEME_ID_DEFAULT = "default";
        public static final String SCHEME_ID_ALTERNATIVE = "alternative";
        public static final String SCHEME_ID_RAINBOW = "rainbow";
    }
}

