/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.basic.graph;

import java.io.Serializable;
import org.eclipse.scout.rt.shared.data.basic.graph.GraphColor;
import org.eclipse.scout.rt.shared.data.basic.graph.GraphCoordinate;
import org.eclipse.scout.rt.shared.data.basic.graph.GraphNodeSize;
import org.eclipse.scout.rt.shared.data.basic.graph.GraphShape;

public class GraphNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_label;
    private String m_url;
    private GraphShape m_shape;
    private GraphColor m_color;
    private String m_cssClass;
    private GraphNodeSize m_size;
    private GraphCoordinate m_location;
    private Long m_order;

    protected GraphNode() {
    }

    public static GraphNode create() {
        return new GraphNode();
    }

    public static GraphNode create(String label, String url, GraphShape shape, GraphColor color, String cssClass, GraphNodeSize size, GraphCoordinate location, Long order) {
        return GraphNode.create().withLabel(label).withUrl(url).withShape(shape).withColor(color).withCssClass(cssClass).withSize(size).withLocation(location).withOrder(order);
    }

    public GraphNode withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public GraphNode withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public GraphNode withShape(GraphShape shape) {
        this.setShape(shape);
        return this;
    }

    public GraphNode withColor(GraphColor color) {
        this.setColor(color);
        return this;
    }

    public GraphNode withCssClass(String cssClass) {
        this.setCssClass(cssClass);
        return this;
    }

    public GraphNode withSize(GraphNodeSize size) {
        this.setSize(size);
        return this;
    }

    public GraphNode withLocation(GraphCoordinate location) {
        this.setLocation(location);
        return this;
    }

    public GraphNode withOrder(Long order) {
        this.setOrder(order);
        return this;
    }

    public String getLabel() {
        return this.m_label;
    }

    protected void setLabel(String label) {
        this.m_label = label;
    }

    public String getUrl() {
        return this.m_url;
    }

    protected void setUrl(String url) {
        this.m_url = url;
    }

    public GraphShape getShape() {
        return this.m_shape;
    }

    protected void setShape(GraphShape shape) {
        this.m_shape = shape;
    }

    public GraphColor getColor() {
        return this.m_color;
    }

    protected void setColor(GraphColor color) {
        this.m_color = color;
    }

    public String getCssClass() {
        return this.m_cssClass;
    }

    protected void setCssClass(String cssClass) {
        this.m_cssClass = cssClass;
    }

    public GraphNodeSize getSize() {
        return this.m_size;
    }

    protected void setSize(GraphNodeSize size) {
        this.m_size = size;
    }

    public GraphCoordinate getLocation() {
        return this.m_location;
    }

    protected void setLocation(GraphCoordinate location) {
        this.m_location = location;
    }

    public Long getOrder() {
        return this.m_order;
    }

    protected void setOrder(Long order) {
        this.m_order = order;
    }
}

