/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.basic.graph;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.shared.data.basic.graph.GraphEdge;
import org.eclipse.scout.rt.shared.data.basic.graph.GraphNode;

public class GraphModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<GraphNode> m_nodes = new HashSet<GraphNode>();
    private final Set<GraphEdge> m_edges = new HashSet<GraphEdge>();

    protected GraphModel() {
    }

    public static GraphModel create() {
        return new GraphModel();
    }

    public static GraphModel create(Collection<GraphNode> nodes, Collection<GraphEdge> edges) {
        return GraphModel.create().withNodes(nodes).withEdges(edges);
    }

    public GraphModel withNodes(GraphNode ... nodes) {
        if (nodes != null) {
            this.getNodes().clear();
            GraphNode[] graphNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                GraphNode node = graphNodeArray[n2];
                this.addNode(node);
                ++n2;
            }
        }
        return this;
    }

    public GraphModel withNodes(Collection<GraphNode> nodes) {
        if (nodes != null) {
            this.getNodes().clear();
            for (GraphNode node : nodes) {
                this.addNode(node);
            }
        }
        return this;
    }

    public GraphModel withEdges(GraphEdge ... edges) {
        if (edges != null) {
            this.getEdges().clear();
            GraphEdge[] graphEdgeArray = edges;
            int n = edges.length;
            int n2 = 0;
            while (n2 < n) {
                GraphEdge edge = graphEdgeArray[n2];
                this.addEdge(edge);
                ++n2;
            }
        }
        return this;
    }

    public GraphModel withEdges(Collection<GraphEdge> edges) {
        if (edges != null) {
            this.getEdges().clear();
            for (GraphEdge edge : edges) {
                this.addEdge(edge);
            }
        }
        return this;
    }

    public Set<GraphNode> getNodes() {
        return this.m_nodes;
    }

    public Set<GraphEdge> getEdges() {
        return this.m_edges;
    }

    public void addNode(GraphNode node) {
        this.m_nodes.add(node);
    }

    public void addEdge(GraphEdge edge) {
        this.m_edges.add(edge);
    }
}

