/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.basic;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.util.Assertions;

public final class NamedBitMaskHelper {
    public static final byte NUM_BITS = 8;
    public static final byte ALL_BITS_SET = -1;
    public static final byte NO_BITS_SET = 0;
    private final Map<String, Byte> m_masksByBitName = new ConcurrentHashMap<String, Byte>(8);
    private byte m_nextIndex = 0;

    public NamedBitMaskHelper(String ... usedBitNames) {
        if (usedBitNames != null && usedBitNames.length > 0) {
            String[] stringArray = usedBitNames;
            int n = usedBitNames.length;
            int n2 = 0;
            while (n2 < n) {
                String usedName = stringArray[n2];
                this.bitMaskFor(usedName);
                ++n2;
            }
        }
    }

    public NamedBitMaskHelper() {
        this(null);
    }

    public byte changeBit(String bitName, boolean newBitValue, byte holder) {
        byte mask = this.bitMaskFor(bitName);
        if (newBitValue) {
            return (byte)(holder | mask);
        }
        return (byte)(holder & ~mask);
    }

    public byte setBit(String bitName, byte holder) {
        return this.changeBit(bitName, true, holder);
    }

    public byte clearBit(String bitName, byte holder) {
        return this.changeBit(bitName, false, holder);
    }

    public boolean isBitSet(String bitName, byte holder) {
        return (holder & this.bitMaskFor(bitName)) != 0;
    }

    public boolean isBit(String bitName, byte holder, boolean expectedValue) {
        return expectedValue == this.isBitSet(bitName, holder);
    }

    public static boolean allBitsSet(byte holder) {
        return holder == -1;
    }

    public synchronized int usedBits() {
        return this.m_nextIndex;
    }

    public boolean allBitsEqual(byte holder, Predicate<String> filter) {
        for (String name : this.bitNames()) {
            if (this.isBit(name, holder, filter == null || filter.test(name))) continue;
            return false;
        }
        return true;
    }

    public Set<String> bitNames() {
        return Collections.unmodifiableSet(this.m_masksByBitName.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte bitMaskFor(String bitName) {
        Byte mask = this.m_masksByBitName.get(Assertions.assertNotNull((Object)bitName));
        if (mask != null) {
            return mask;
        }
        NamedBitMaskHelper namedBitMaskHelper = this;
        synchronized (namedBitMaskHelper) {
            mask = this.m_masksByBitName.get(bitName);
            if (mask != null) {
                return mask;
            }
            return this.leaseNewMaskFor(bitName);
        }
    }

    private byte leaseNewMaskFor(String bitName) {
        if (this.m_nextIndex >= 8) {
            throw new IllegalStateException("Too many entries. Currently only 8 entries are supported.");
        }
        byte result = NamedBitMaskHelper.bitMaskFor(this.m_nextIndex);
        this.m_nextIndex = (byte)(this.m_nextIndex + 1);
        this.m_masksByBitName.put(bitName, result);
        return result;
    }

    private static byte bitMaskFor(byte index) {
        return (byte)(1 << index);
    }
}

