/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.basic;

import java.io.Serializable;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class MemoryOptimizedObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private short m_bits;
    private Object[] m_data = new Object[0];

    protected synchronized boolean setValueInternal(int bitPos, Object newValue) {
        int index = this.getIndexFor(bitPos);
        if (index >= 0) {
            Object oldValue = this.m_data[index];
            if (newValue != null) {
                this.m_data[index] = newValue;
            } else {
                Object[] newData = new Object[this.m_data.length - 1];
                System.arraycopy(this.m_data, 0, newData, 0, index);
                System.arraycopy(this.m_data, index + 1, newData, index, this.m_data.length - index - 1);
                this.m_data = newData;
                this.m_bits = (short)(this.m_bits - (1 << bitPos));
            }
            return ObjectUtility.notEquals((Object)oldValue, (Object)newValue);
        }
        if (newValue != null) {
            int setCountBefore = 0;
            int i = 0;
            while (i < bitPos) {
                if ((this.m_bits & 1 << i) != 0) {
                    ++setCountBefore;
                }
                ++i;
            }
            index = setCountBefore;
            Object[] newData = new Object[this.m_data.length + 1];
            System.arraycopy(this.m_data, 0, newData, 0, index);
            newData[index] = newValue;
            System.arraycopy(this.m_data, index, newData, index + 1, this.m_data.length - index);
            this.m_data = newData;
            this.m_bits = (short)(this.m_bits | 1 << bitPos);
            return true;
        }
        return false;
    }

    protected synchronized Object getValueInternal(int bitPos) {
        int index = this.getIndexFor(bitPos);
        if (index >= 0) {
            return this.m_data[index];
        }
        return null;
    }

    private int getIndexFor(int bitPos) {
        if ((this.m_bits & 1 << bitPos) != 0) {
            int setCount = 0;
            int i = 0;
            while (i <= bitPos) {
                if ((this.m_bits & 1 << i) != 0) {
                    ++setCount;
                }
                ++i;
            }
            return setCount - 1;
        }
        return -1;
    }

    protected void setIfNotDefault(int bit, boolean value, boolean defaultValue) {
        if (value == defaultValue) {
            this.setValueInternal(bit, null);
        } else {
            this.setValueInternal(bit, value);
        }
    }

    protected <T> T getOrElse(int valueBit, T defaultValue) {
        if (this.getValueInternal(valueBit) == null) {
            return defaultValue;
        }
        return (T)this.getValueInternal(valueBit);
    }
}

