/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.clientnotification;

import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public interface IClientNotificationAddress
extends Serializable {
    public Set<String> getSessionIds();

    public Set<String> getUserIds();

    public boolean isNotifyAllSessions();

    public boolean isNotifyAllNodes();

    default public String prettyPrint() {
        if (this.isNotifyAllNodes()) {
            return "all nodes";
        }
        if (this.isNotifyAllSessions()) {
            return "all sessions";
        }
        if (CollectionUtility.hasElements(this.getUserIds())) {
            return this.getUserIds().stream().sorted().collect(Collectors.joining(", ", "users [", "]"));
        }
        if (CollectionUtility.hasElements(this.getSessionIds())) {
            return this.getSessionIds().stream().sorted().collect(Collectors.joining(", ", "sessions [", "]"));
        }
        return "unknown";
    }
}

