/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.logging;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.logger.DiagnosticContextValueProcessor;
import org.eclipse.scout.rt.server.commons.servlet.logging.HttpRequestMethodContextValueProvider;
import org.eclipse.scout.rt.server.commons.servlet.logging.HttpRequestQueryStringContextValueProvider;
import org.eclipse.scout.rt.server.commons.servlet.logging.HttpRequestUriContextValueProvider;
import org.eclipse.scout.rt.server.commons.servlet.logging.HttpSessionIdContextValueProvider;
import org.eclipse.scout.rt.server.commons.servlet.logging.HttpSessionIdLogHelper;

@ApplicationScoped
public class ServletDiagnosticsProviderFactory {
    public List<DiagnosticContextValueProcessor.IDiagnosticContextValueProvider> getProviders(HttpServletRequest request, HttpServletResponse response) {
        ArrayList<DiagnosticContextValueProcessor.IDiagnosticContextValueProvider> providers = new ArrayList<DiagnosticContextValueProcessor.IDiagnosticContextValueProvider>();
        providers.add(new HttpRequestMethodContextValueProvider(request.getMethod()));
        providers.add(new HttpRequestQueryStringContextValueProvider(request.getQueryString()));
        providers.add(new HttpRequestUriContextValueProvider(request.getRequestURI()));
        providers.add(new HttpSessionIdContextValueProvider(this.getHttpSessionIdContextValue(request.getSession(false))));
        return providers;
    }

    protected String getHttpSessionIdContextValue(HttpSession session) {
        if (session == null) {
            return null;
        }
        return ((HttpSessionIdLogHelper)BEANS.get(HttpSessionIdLogHelper.class)).getSessionIdForLogging(session);
    }
}

