/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.filter.gzip;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.server.commons.BufferedServletOutputStream;

@Deprecated
public class LegacyGzipServletResponseWrapper
extends HttpServletResponseWrapper {
    private BufferedServletOutputStream m_buf;
    private int m_compressedLength = -1;
    private int m_uncompressedLength = -1;
    private ServletOutputStream m_servletOut;
    private PrintWriter m_writer;

    public LegacyGzipServletResponseWrapper(HttpServletResponse resp) {
        super(resp);
    }

    protected BufferedServletOutputStream ensureBufferedStream() {
        if (this.m_buf == null) {
            this.m_buf = new BufferedServletOutputStream();
        }
        return this.m_buf;
    }

    public int getCompressedLength() {
        return this.m_compressedLength;
    }

    public int getUncompressedLength() {
        return this.m_uncompressedLength;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.m_writer != null) {
            throw new IllegalStateException("getWriter was previsouly called, getOutputStream is not available");
        }
        if (this.m_servletOut == null) {
            this.m_servletOut = this.ensureBufferedStream();
        }
        return this.m_servletOut;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.m_servletOut != null) {
            throw new IllegalStateException("getOutputStream was previsouly called, getWriter is not available");
        }
        if (this.m_writer == null) {
            this.m_writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.ensureBufferedStream()), this.getResponse().getCharacterEncoding()));
        }
        return this.m_writer;
    }

    public void setContentLength(int len) {
    }

    public void flushBuffer() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
        if (this.m_buf != null) {
            this.m_buf.flush();
        }
        super.flushBuffer();
    }

    public boolean finish(int minimumLengthToCompress) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.close();
            this.m_writer = null;
        }
        boolean compressed = false;
        if (this.m_buf != null) {
            byte[] gzipped;
            this.m_buf.close();
            byte[] raw = this.m_buf.getContent();
            this.m_uncompressedLength = raw.length;
            this.m_buf = null;
            HttpServletResponse res = (HttpServletResponse)this.getResponse();
            if (minimumLengthToCompress >= 0 && this.m_uncompressedLength >= minimumLengthToCompress) {
                gzipped = IOUtility.compressGzip((byte[])raw);
                res.addHeader("Content-Encoding", "gzip");
                compressed = true;
            } else {
                gzipped = raw;
            }
            this.m_compressedLength = gzipped.length;
            raw = null;
            res.setContentLength(gzipped.length);
            res.getOutputStream().write(gzipped);
            super.flushBuffer();
        }
        return compressed;
    }
}

