/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.filter.gzip;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ConnectionErrorDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GzipServletOutputStream
extends ServletOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(GzipServletOutputStream.class);
    private final HttpServletResponse m_response;
    private final ServletOutputStream m_servletOutputStream;
    private GZIPOutputStream m_gzipOutputStream;
    private byte[] m_buf;
    private int m_bufCount = 0;
    private volatile Object m_writeListener;

    public GzipServletOutputStream(int compressThreshold, HttpServletResponse response) throws IOException {
        this.m_response = response;
        this.m_servletOutputStream = response.getOutputStream();
        this.m_buf = this.createBuffer(compressThreshold);
    }

    protected byte[] createBuffer(int size) {
        return new byte[size];
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
        this.m_writeListener = Assertions.assertNotNull((Object)writeListener);
        try {
            writeListener.onWritePossible();
        }
        catch (IOException e) {
            writeListener.onError((Throwable)e);
        }
    }

    protected GZIPOutputStream ensureGzipOutStream() throws IOException {
        if (this.m_gzipOutputStream == null) {
            this.m_response.addHeader("Content-Encoding", "gzip");
            this.m_gzipOutputStream = new GZIPOutputStream((OutputStream)this.m_servletOutputStream);
        }
        return this.m_gzipOutputStream;
    }

    protected void flushBufferToGzipOutputStream() throws IOException {
        if (this.m_bufCount == 0) {
            return;
        }
        this.writeToGzipOutputStream(this.m_buf, 0, this.m_bufCount);
        this.m_bufCount = 0;
    }

    protected void writeToGzipOutputStream(byte[] buffer, int off, int len) throws IOException {
        this.ensureGzipOutStream().write(buffer, off, len);
    }

    protected boolean fitsIntoBuffer(int len) {
        return this.m_buf.length - this.m_bufCount >= len;
    }

    public void write(int b) throws IOException {
        if (this.m_gzipOutputStream == null && this.fitsIntoBuffer(1)) {
            this.m_buf[this.m_bufCount] = (byte)b;
            ++this.m_bufCount;
            return;
        }
        try {
            this.flushBufferToGzipOutputStream();
            this.writeToGzipOutputStream(new byte[]{(byte)b}, 0, 1);
        }
        catch (IOException e) {
            WriteListener listener = (WriteListener)this.m_writeListener;
            if (listener != null) {
                listener.onError((Throwable)e);
            }
            throw e;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.m_gzipOutputStream == null && this.fitsIntoBuffer(len)) {
            System.arraycopy(b, off, this.m_buf, this.m_bufCount, len);
            this.m_bufCount += len;
            return;
        }
        try {
            this.flushBufferToGzipOutputStream();
            this.writeToGzipOutputStream(b, off, len);
        }
        catch (Exception e) {
            WriteListener listener = (WriteListener)this.m_writeListener;
            if (listener != null) {
                listener.onError((Throwable)e);
            }
            if (((ConnectionErrorDetector)BEANS.get(ConnectionErrorDetector.class)).isConnectionError((Throwable)e)) {
                LOG.debug("Connection error detected: exception class={}, message={}.", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
                return;
            }
            throw e;
        }
    }

    public void close() throws IOException {
        if (this.m_gzipOutputStream != null) {
            this.m_gzipOutputStream.close();
            this.m_gzipOutputStream = null;
        } else if (this.m_bufCount > 0) {
            this.m_servletOutputStream.write(this.m_buf, 0, this.m_bufCount);
            this.m_bufCount = 0;
        }
    }

    public void flush() throws IOException {
        if (this.m_gzipOutputStream != null) {
            this.m_gzipOutputStream.flush();
        }
    }
}

