/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(LogFilter.class);
    public static final String NO_LOG_REQUEST_ATTRIBUTE = "scout.noLog";

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        long t0 = System.nanoTime();
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        if (this.isLoggable(httpRequest, httpResponse)) {
            this.log(httpRequest, httpResponse, System.nanoTime() - t0);
        }
    }

    protected boolean isLoggable(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        return httpRequest != null && httpRequest.getAttribute(NO_LOG_REQUEST_ATTRIBUTE) == null;
    }

    protected void log(HttpServletRequest httpRequest, HttpServletResponse httpResponse, long durationNanos) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {} {}{} took {} ms [User-Agent: {}; Accept-Language: {}, Referer: {}; Remote-Addr: {}; X-Forwarded-For: {}]", new Object[]{httpResponse.getStatus(), httpRequest.getMethod(), this.urlDecode(httpRequest.getRequestURL().toString()), httpRequest.getQueryString() == null ? "" : "?" + this.urlDecode(httpRequest.getQueryString()), StringUtility.formatNanos((long)durationNanos), ObjectUtility.nvl((Object)httpRequest.getHeader("User-Agent"), (Object)"-"), ObjectUtility.nvl((Object)httpRequest.getHeader("Accept-Language"), (Object)"-"), ObjectUtility.nvl((Object)httpRequest.getHeader("Referer"), (Object)"-"), ObjectUtility.nvl((Object)httpRequest.getRemoteAddr(), (Object)"-"), ObjectUtility.nvl((Object)httpRequest.getHeader("X-Forwarded-For"), (Object)"-")});
        } else if (LOG.isInfoEnabled()) {
            LOG.info("[{}] {} {} took {} ms", new Object[]{httpResponse.getStatus(), httpRequest.getMethod(), this.urlDecode(httpRequest.getRequestURL().toString()), StringUtility.formatNanos((long)durationNanos)});
        }
    }

    protected String urlDecode(String s) {
        return IOUtility.urlDecode((String)s);
    }

    public void destroy() {
    }
}

