/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.server.commons.opentelemetry.HttpServletRequestTextMapGetter;
import org.eclipse.scout.rt.server.commons.opentelemetry.OpenTelemetryFilterInstrumenterFactory;
import org.eclipse.scout.rt.server.commons.opentelemetry.SpanNamePropagationFromDownstream;

public class OpenTelemetryFilter
implements Filter {
    private Instrumenter<HttpServletRequest, HttpServletResponse> m_instrumenter;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_instrumenter = ((OpenTelemetryFilterInstrumenterFactory)BEANS.get(OpenTelemetryFilterInstrumenterFactory.class)).createInstrumenter();
    }

    public void doFilter(ServletRequest request0, ServletResponse response0, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)request0;
        HttpServletResponse response = (HttpServletResponse)response0;
        Context parentContext = GlobalOpenTelemetry.get().getPropagators().getTextMapPropagator().extract(Context.current(), (Object)request, (TextMapGetter)BEANS.get(HttpServletRequestTextMapGetter.class));
        if (!this.m_instrumenter.shouldStart(parentContext, (Object)request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Context context = this.m_instrumenter.start(parentContext, (Object)request);
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (Scope ignored = context.makeCurrent();){
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                SpanNamePropagationFromDownstream.updateSpanName(request.getMethod());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            this.m_instrumenter.end(context, (Object)request, (Object)response, t);
            throw t;
        }
        this.m_instrumenter.end(context, (Object)request, (Object)response, null);
    }
}

