/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hc.client5.http.ContextBuilder;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.support.AsyncRequestBuilder;
import org.apache.hc.core5.http.nio.support.classic.AbstractClassicEntityConsumer;
import org.apache.hc.core5.http.nio.support.classic.AbstractClassicEntityProducer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.support.AbstractRequestBuilder;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.context.CorrelationId;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.job.internal.JobManager;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ConnectionErrorDetector;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.server.commons.servlet.AlreadyInvalidatedException;
import org.eclipse.scout.rt.server.commons.servlet.HttpHeaderNameFilter;
import org.eclipse.scout.rt.server.commons.servlet.HttpProxyConfigProperties;
import org.eclipse.scout.rt.server.commons.servlet.HttpProxyRequestOptions;
import org.eclipse.scout.rt.server.commons.servlet.IHttpHeaderFilter;
import org.eclipse.scout.rt.server.commons.servlet.IRewriteRule;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.http.async.AbstractAsyncHttpClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.event.Level;

@Bean
public class HttpProxy {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProxy.class);
    private AbstractAsyncHttpClientManager m_httpClientManager;
    private int m_initialBufferSize = 4096;
    private String m_remoteBaseUrl;
    private final List<IHttpHeaderFilter> m_requestHeaderFilters;
    private final List<IHttpHeaderFilter> m_responseHeaderFilters;
    private final CookieStore m_defaultCookieStore;
    private final LazyValue<ConnectionErrorDetector> m_connectionErrorDetector = new LazyValue(ConnectionErrorDetector.class);
    private Executor m_blockingOperationExecutor;
    private Function<ContextBuilder, HttpClientContext> m_httpClientContextInterceptor;

    public HttpProxy() {
        this.m_httpClientManager = (AbstractAsyncHttpClientManager)BEANS.get((Class)((Class)CONFIG.getPropertyValue(HttpProxyConfigProperties.HttpProxyAsyncHttpClientManagerConfigProperty.class)));
        this.m_requestHeaderFilters = new ArrayList<IHttpHeaderFilter>();
        this.m_responseHeaderFilters = new ArrayList<IHttpHeaderFilter>();
        this.m_defaultCookieStore = this.initializeDefaultCookieStore();
    }

    @PostConstruct
    protected void initialize() {
        HashSet hopByHopRequestHeaders = CollectionUtility.hashSet((Object[])new String[]{"Connection", "Upgrade", "Keep-Alive", "Transfer-Encoding", "Proxy-Authorization", "TE"});
        for (String header : hopByHopRequestHeaders) {
            this.m_requestHeaderFilters.add(new HttpHeaderNameFilter(header));
        }
        HashSet hopByHopResponseHeaders = CollectionUtility.hashSet((Object[])new String[]{"Connection", "Keep-Alive", "Transfer-Encoding", "Proxy-Authenticate", "Trailer"});
        for (String header : hopByHopResponseHeaders) {
            this.m_responseHeaderFilters.add(new HttpHeaderNameFilter(header));
        }
        this.m_requestHeaderFilters.add(new HttpHeaderNameFilter("Content-Length"));
        this.m_requestHeaderFilters.add(new HttpHeaderNameFilter("Host"));
        this.m_responseHeaderFilters.add(new HttpHeaderNameFilter(null));
        this.m_blockingOperationExecutor = this.createBlockingOperationExecutor();
    }

    public CookieStore getDefaultCookieStore() {
        return this.m_defaultCookieStore;
    }

    protected CookieStore initializeDefaultCookieStore() {
        return this.m_httpClientManager.getCookieStore();
    }

    protected CookieStore createSpecificSessionCookieStore(ISession session) {
        return new SpecificSessionCookieStore(session);
    }

    protected ExecutorService createBlockingOperationExecutor() {
        return ((JobManager)BEANS.get(JobManager.class)).getExecutor();
    }

    protected boolean shouldIncludeRequestPayload(HttpServletRequest req) {
        return ObjectUtility.isOneOf((Object)req.getMethod(), (Object)"POST", (Object[])new Object[]{"PUT", "PATCH"});
    }

    protected boolean shouldWriteParametersAsPayload(HttpServletRequest req) {
        if (req.getParameterMap().isEmpty()) {
            return false;
        }
        String contentType = req.getContentType();
        if (contentType == null) {
            return false;
        }
        int i = contentType.indexOf(";");
        if (i != -1) {
            contentType = contentType.substring(0, i);
        }
        return "application/x-www-form-urlencoded".equalsIgnoreCase(contentType);
    }

    public void proxy(HttpServletRequest req, HttpServletResponse resp, HttpProxyRequestOptions options) throws IOException {
        AsyncContext asyncContext = req.startAsync((ServletRequest)req, (ServletResponse)resp);
        asyncContext.setTimeout(((Long)CONFIG.getPropertyValue(HttpProxyConfigProperties.HttpProxyAsyncTimeoutConfigProperty.class)).longValue());
        if (options == null) {
            options = new HttpProxyRequestOptions();
        }
        String url = this.rewriteUrl(req, options);
        LOG.debug("Forwarding {} request to {}", (Object)req.getMethod(), (Object)url);
        AsyncRequestBuilder asyncRequestBuilder = this.prepareRequest(AsyncRequestBuilder.create((String)req.getMethod()).setUri(url));
        this.writeRequestHeaders(req, (AbstractRequestBuilder)asyncRequestBuilder);
        this.writeCustomRequestHeaders((AbstractRequestBuilder)asyncRequestBuilder, options.getCustomRequestHeaders());
        if (this.shouldIncludeRequestPayload(req)) {
            if (this.shouldWriteParametersAsPayload(req)) {
                this.writeRequestParameters(req, asyncRequestBuilder);
            } else {
                asyncRequestBuilder.setEntity(this.createEntityProducer(req));
            }
        }
        LOG.trace("Executing request for {}", (Object)url);
        Future future = this.getHttpClientManager().getClient().execute(asyncRequestBuilder.build(), this.createAsyncResponseConsumer(resp), this.createHttpContext(), this.createExecuteCallback(resp, asyncContext));
        this.addCancelListener(asyncContext, future);
    }

    protected HttpContext createHttpContext() {
        Function<ContextBuilder, HttpClientContext> httpClientContextInterceptor;
        ContextBuilder contextBuilder = ContextBuilder.create();
        ISession currentSession = (ISession)ISession.CURRENT.get();
        CookieStore defaultCookieStore = this.getDefaultCookieStore();
        if (defaultCookieStore != null) {
            if (currentSession != null) {
                contextBuilder.useCookieStore(this.createSpecificSessionCookieStore(currentSession));
            } else {
                contextBuilder.useCookieStore(defaultCookieStore);
            }
        }
        if ((httpClientContextInterceptor = this.getHttpClientContextInterceptor()) != null) {
            return (HttpContext)httpClientContextInterceptor.apply(contextBuilder);
        }
        return contextBuilder.build();
    }

    protected String rewriteUrl(HttpServletRequest req, HttpProxyRequestOptions options) {
        String pathInfo = (String)ObjectUtility.nvl((Object)req.getPathInfo(), (Object)"");
        IRewriteRule rewriteRule = options.getRewriteRule();
        if (rewriteRule != null) {
            pathInfo = rewriteRule.rewrite(pathInfo);
        }
        pathInfo = IOUtility.urlEncode((String)pathInfo).replaceAll("%2F", "/");
        return StringUtility.join((String)"?", (Object[])new Object[]{StringUtility.join((String)"", (Object[])new Object[]{this.getRemoteBaseUrl(), pathInfo}), req.getQueryString()});
    }

    protected AsyncRequestBuilder prepareRequest(AsyncRequestBuilder asyncRequestBuilder) {
        return asyncRequestBuilder;
    }

    protected void writeRequestHeaders(HttpServletRequest req, AbstractRequestBuilder requestBuilder) {
        Enumeration headerNames = req.getHeaderNames();
        Set<String> hopByHopHeaderNames = this.getConnectionHeaderValues(req);
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            String value = req.getHeader(name);
            if (name != null && hopByHopHeaderNames.contains(name.toLowerCase(Locale.US))) {
                LOG.trace("Removed hop-by-hop request header: {} (original value: {})", (Object)name, (Object)req.getHeader(name));
                continue;
            }
            for (IHttpHeaderFilter filter : this.getRequestHeaderFilters()) {
                value = filter.filter(name, value);
            }
            if (value != null) {
                requestBuilder.addHeader(name, value);
                LOG.trace("Added request header: {}: {}", (Object)name, (Object)value);
                continue;
            }
            LOG.trace("Removed request header: {} (original value: {})", (Object)name, (Object)req.getHeader(name));
        }
    }

    protected void writeCustomRequestHeaders(AbstractRequestBuilder requestBuilder, Map<String, String> customHeaders) {
        if (customHeaders == null) {
            return;
        }
        for (Map.Entry<String, String> header : customHeaders.entrySet()) {
            String name = header.getKey();
            if (name == null) continue;
            String value = header.getValue();
            Header existingHeader = requestBuilder.getFirstHeader(name);
            requestBuilder.removeHeaders(name);
            if (value != null) {
                requestBuilder.addHeader(name, value);
                LOG.trace("Added custom request header: {}: {}", (Object)name, (Object)value);
                continue;
            }
            if (existingHeader == null) continue;
            LOG.trace("Removed custom request header: {} (original value: {})", (Object)name, (Object)existingHeader.getValue());
        }
    }

    protected void writeRequestPayload(HttpServletRequest req, OutputStream outputStream) throws IOException {
        ServletInputStream inputStream = req.getInputStream();
        if (inputStream == null) {
            return;
        }
        IOUtility.writeFromToStream((OutputStream)outputStream, (InputStream)inputStream);
    }

    protected void writeRequestParameters(HttpServletRequest req, AsyncRequestBuilder requestBuilder) {
        String parameters = this.formatFormParameters(req.getParameterMap());
        requestBuilder.setEntity(parameters);
    }

    protected String formatFormParameters(Map<String, String[]> parameterMap) {
        StringBuilder parameters = new StringBuilder();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String[] stringArray = entry.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (parameters.length() > 0) {
                    parameters.append("&");
                }
                parameters.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8));
                ++n2;
            }
        }
        return parameters.toString();
    }

    protected void writeResponseStatus(HttpServletResponse resp, HttpResponse httpResp) {
        int responseCode = httpResp.getCode();
        resp.setStatus(responseCode);
    }

    protected void writeResponsePayload(HttpServletResponse resp, InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        try {
            IOUtility.writeFromToStream((OutputStream)resp.getOutputStream(), (InputStream)inputStream);
        }
        catch (IOException e) {
            inputStream.close();
            throw e;
        }
    }

    protected void writeResponseHeaders(String correlationId, HttpServletResponse resp, HttpResponse httpResp) {
        Set<String> hopByHopHeaderNames = this.getConnectionHeaderValues(httpResp);
        Header[] headerArray = httpResp.getHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            String name = header.getName();
            String value = header.getValue();
            if (name != null && hopByHopHeaderNames.contains(name.toLowerCase(Locale.US))) {
                this.log(Level.TRACE, correlationId, "Removed hop-by-hop response header: {} (original value: {})", name, value);
            } else {
                String originalValue = value;
                for (IHttpHeaderFilter filter : this.getResponseHeaderFilters()) {
                    value = filter.filter(name, value);
                }
                if (value != null) {
                    resp.setHeader(name, value);
                    this.log(Level.TRACE, correlationId, "Added response header: {}: {}", name, value);
                } else {
                    this.log(Level.TRACE, correlationId, "Removed response header: {} (original value: {})", name, originalValue);
                }
            }
            ++n2;
        }
    }

    protected Set<String> getConnectionHeaderValues(HttpServletRequest req) {
        Enumeration enumeration = req.getHeaders("Connection");
        if (enumeration == null) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            String s = (String)enumeration.nextElement();
            if (!StringUtility.hasText((CharSequence)s)) continue;
            set.add(s.toLowerCase(Locale.US));
        }
        return set;
    }

    protected Set<String> getConnectionHeaderValues(HttpResponse httpResp) {
        return Arrays.stream(httpResp.getHeaders()).filter(h -> "Connection".equals(h.getName())).map(NameValuePair::getValue).flatMap(v -> Stream.of(StringUtility.split((String)v, (String)","))).filter(StringUtility::hasText).map(StringUtility::trim).map(s -> s.toLowerCase(Locale.US)).collect(Collectors.toSet());
    }

    protected void addCancelListener(AsyncContext asyncContext, Future<Boolean> future) {
        try {
            asyncContext.addListener(this.createCancelListener(future));
        }
        catch (IllegalStateException e) {
            LOG.info("Unable to add timeout/error listener for proxy request, maybe request was already completed", (Throwable)e);
        }
    }

    protected AsyncListener createCancelListener(final Future<Boolean> future) {
        return new AsyncListener(){

            public void onComplete(AsyncEvent event) {
            }

            public void onTimeout(AsyncEvent event) {
                LOG.info("Servlet request timed-out, cancelling proxy request", event.getThrowable());
                future.cancel(true);
            }

            public void onError(AsyncEvent event) {
                LOG.info("Error while forwarding servlet request to proxy, cancelling proxy request", event.getThrowable());
                future.cancel(true);
            }

            public void onStartAsync(AsyncEvent event) {
            }
        };
    }

    public AbstractAsyncHttpClientManager getHttpClientManager() {
        return this.m_httpClientManager;
    }

    public HttpProxy withHttpClientManager(AbstractAsyncHttpClientManager manager) {
        this.m_httpClientManager = manager;
        return this;
    }

    public int getInitialBufferSize(HttpServletRequest request) {
        return this.m_initialBufferSize;
    }

    public int getInitialBufferSize(HttpServletResponse response) {
        return this.m_initialBufferSize;
    }

    public HttpProxy withInitialBufferSize(int initialBufferSize) {
        this.m_initialBufferSize = initialBufferSize;
        return this;
    }

    public String getRemoteBaseUrl() {
        return this.m_remoteBaseUrl;
    }

    public HttpProxy withRemoteBaseUrl(String remoteBaseUrl) {
        if (remoteBaseUrl != null && remoteBaseUrl.endsWith("/")) {
            remoteBaseUrl = remoteBaseUrl.substring(0, remoteBaseUrl.length() - 1);
        }
        this.m_remoteBaseUrl = remoteBaseUrl;
        return this;
    }

    public List<IHttpHeaderFilter> getRequestHeaderFilters() {
        return this.m_requestHeaderFilters;
    }

    public HttpProxy withRequestHeaderFilter(IHttpHeaderFilter filter) {
        this.m_requestHeaderFilters.add(filter);
        return this;
    }

    public List<IHttpHeaderFilter> getResponseHeaderFilters() {
        return this.m_responseHeaderFilters;
    }

    public HttpProxy withResponseHeaderFilter(IHttpHeaderFilter filter) {
        this.m_responseHeaderFilters.add(filter);
        return this;
    }

    public Executor getBlockingOperationExecutor() {
        return this.m_blockingOperationExecutor;
    }

    public Function<ContextBuilder, HttpClientContext> getHttpClientContextInterceptor() {
        return this.m_httpClientContextInterceptor;
    }

    public HttpProxy withHttpClientContextSupplier(Function<ContextBuilder, HttpClientContext> httpClientContextSupplier) {
        this.m_httpClientContextInterceptor = httpClientContextSupplier;
        return this;
    }

    protected AsyncEntityProducer createEntityProducer(final HttpServletRequest req) {
        return new AbstractClassicEntityProducer(this.getInitialBufferSize(req), null, this.getBlockingOperationExecutor()){

            protected void produceData(ContentType contentType, OutputStream outputStream) throws IOException {
                LOG.trace("Producing data for forwarded request (original uri: {})", (Object)req.getRequestURI());
                HttpProxy.this.writeRequestPayload(req, outputStream);
            }
        };
    }

    protected AsyncEntityConsumer<Boolean> createEntityConsumer(final HttpServletResponse resp) {
        AbstractClassicEntityConsumer<Boolean> entityConsumer = new AbstractClassicEntityConsumer<Boolean>(this.getInitialBufferSize(resp), this.getBlockingOperationExecutor()){
            private final String m_correlationId;
            {
                super($anonymous0, $anonymous1);
                this.m_correlationId = (String)CorrelationId.CURRENT.get();
            }

            protected Boolean consumeData(ContentType contentType, InputStream inputStream) throws IOException {
                HttpProxy.this.log(Level.TRACE, this.m_correlationId, "Consuming data with contentType {}", contentType);
                HttpProxy.this.writeResponsePayload(resp, inputStream);
                return true;
            }
        };
        return entityConsumer;
    }

    protected AsyncResponseConsumer<Boolean> createAsyncResponseConsumer(final HttpServletResponse resp) {
        AsyncResponseConsumer<Boolean> consumer = new AsyncResponseConsumer<Boolean>(){
            private final String m_correlationId = (String)CorrelationId.CURRENT.get();
            private volatile AsyncEntityConsumer<Boolean> m_dataConsumer;
            {
                this.m_dataConsumer = HttpProxy.this.createEntityConsumer(httpServletResponse);
            }

            public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext context, FutureCallback<Boolean> resultCallback) throws HttpException, IOException {
                HttpProxy.this.log(Level.TRACE, this.m_correlationId, "Consuming response (protocol version: {})", context.getProtocolVersion());
                HttpProxy.this.writeResponseHeaders(this.m_correlationId, resp, response);
                HttpProxy.this.writeResponseStatus(resp, response);
                if (entityDetails != null) {
                    HttpProxy.this.log(Level.TRACE, this.m_correlationId, "Starting stream for entity (content-type: {})", entityDetails.getContentType());
                    this.m_dataConsumer.streamStart(entityDetails, resultCallback);
                } else {
                    HttpProxy.this.log(Level.TRACE, this.m_correlationId, "No entity data for response", new Object[0]);
                    resultCallback.completed((Object)true);
                }
            }

            public void informationResponse(HttpResponse response, HttpContext context) {
            }

            public void failed(Exception cause) {
                HttpProxy.this.log(Level.TRACE, this.m_correlationId, "Response consumer failed: ", cause);
                if (!((ConnectionErrorDetector)HttpProxy.this.m_connectionErrorDetector.get()).isConnectionError((Throwable)cause)) {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"scout.correlation.id", (String)this.m_correlationId);){
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)cause);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.releaseResources();
            }

            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                this.m_dataConsumer.updateCapacity(capacityChannel);
            }

            public void consume(ByteBuffer src) throws IOException {
                this.m_dataConsumer.consume(src);
            }

            public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                this.m_dataConsumer.streamEnd(trailers);
            }

            public void releaseResources() {
                if (this.m_dataConsumer != null) {
                    this.m_dataConsumer.releaseResources();
                }
                this.m_dataConsumer = null;
            }
        };
        return consumer;
    }

    protected FutureCallback<Boolean> createExecuteCallback(final HttpServletResponse resp, final AsyncContext asyncContext) {
        FutureCallback<Boolean> callback = new FutureCallback<Boolean>(){
            private final String m_correlationId = (String)CorrelationId.CURRENT.get();

            public void completed(Boolean result) {
                HttpProxy.this.log(Level.TRACE, this.m_correlationId, "Request execution completed with result: {}", result);
                Assertions.assertTrue((boolean)result);
                asyncContext.complete();
            }

            public void failed(Exception ex) {
                HttpProxy.this.log(Level.TRACE, this.m_correlationId, "Request execution failed", ex);
                if (!((ConnectionErrorDetector)HttpProxy.this.m_connectionErrorDetector.get()).isConnectionError((Throwable)ex)) {
                    Throwable throwable = null;
                    Object var3_7 = null;
                    try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"scout.correlation.id", (String)this.m_correlationId);){
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                try {
                    boolean alreadyCommitted = resp.isCommitted();
                    if (!alreadyCommitted) {
                        resp.setStatus(HttpProxy.this.computeStatusCodeForFailure(ex));
                    }
                }
                catch (AlreadyInvalidatedException e) {
                    HttpProxy.this.log(Level.TRACE, this.m_correlationId, "Response is invalidated", new Object[]{e});
                }
                try {
                    asyncContext.complete();
                }
                catch (Exception e) {
                    HttpProxy.this.log(Level.WARN, this.m_correlationId, "Unable to complete async context, assuming already completed", e);
                }
            }

            public void cancelled() {
                HttpProxy.this.log(Level.TRACE, this.m_correlationId, "Request execution cancelled", new Object[0]);
                asyncContext.complete();
            }
        };
        return callback;
    }

    protected int computeStatusCodeForFailure(Exception e) {
        if (e instanceof ConnectException) {
            return 503;
        }
        if (((ConnectionErrorDetector)this.m_connectionErrorDetector.get()).isConnectionError((Throwable)e)) {
            return 503;
        }
        if (e instanceof SocketTimeoutException) {
            return 504;
        }
        return 500;
    }

    protected void log(Level level, String correlationId, String msg, Object ... args) {
        if (LOG.isEnabledForLevel(level)) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"scout.correlation.id", (String)correlationId);){
                LOG.atLevel(level).log(msg, args);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private class SpecificSessionCookieStore
    implements CookieStore {
        private ISession m_session;

        public SpecificSessionCookieStore(ISession session) {
            this.m_session = session;
        }

        public void addCookie(Cookie cookie) {
            this.runWithSession(() -> HttpProxy.this.getDefaultCookieStore().addCookie(cookie));
        }

        public List<Cookie> getCookies() {
            return this.callWithSession(() -> ((CookieStore)HttpProxy.this.getDefaultCookieStore()).getCookies());
        }

        public boolean clearExpired(Date date) {
            return this.callWithSession(() -> HttpProxy.this.getDefaultCookieStore().clearExpired(date));
        }

        public void clear() {
            this.runWithSession(() -> ((CookieStore)HttpProxy.this.getDefaultCookieStore()).clear());
        }

        private void runWithSession(IRunnable runnable) {
            RunContexts.copyCurrent((boolean)true).withThreadLocal(ISession.CURRENT, (Object)this.m_session).run(runnable);
        }

        private <R> R callWithSession(Callable<R> callable) {
            return (R)RunContexts.copyCurrent((boolean)true).withThreadLocal(ISession.CURRENT, (Object)this.m_session).call(callable);
        }
    }
}

