/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.opentelemetry;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class SpanNamePropagationFromDownstream
implements ContextCustomizer<HttpServletRequest> {
    private static final ContextKey<List<String>> NAME_CONTEXT_KEY = ContextKey.named((String)"scout-opentelemetry-span-name-propagation-key");

    public Context onStart(Context context, HttpServletRequest httpServletRequest, Attributes startAttributes) {
        return context.with(NAME_CONTEXT_KEY, new ArrayList(1));
    }

    public static void updateSpanName(String spanName) {
        List o = (List)Context.current().get(NAME_CONTEXT_KEY);
        if (CollectionUtility.hasElements((Collection)o)) {
            Span.current().updateName(spanName + " " + StringUtility.join((String)", ", (Collection)o));
        }
    }

    public static void addNameToContext(Supplier<String> nameSupplier) {
        List o = (List)Context.current().get(NAME_CONTEXT_KEY);
        if (o != null) {
            o.add(nameSupplier.get());
        }
    }
}

