/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.healthcheck;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.server.commons.ServerCommonsConfigProperties;
import org.eclipse.scout.rt.server.commons.healthcheck.AbstractHealthChecker;
import org.eclipse.scout.rt.server.commons.healthcheck.HealthCheckCategoryId;
import org.eclipse.scout.rt.server.commons.healthcheck.IHealthChecker;
import org.eclipse.scout.rt.shared.http.DefaultHttpTransportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteHealthChecker
extends AbstractHealthChecker {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteHealthChecker.class);
    private final List<String> m_remoteUrls = (List)((ServerCommonsConfigProperties.RemoteHealthCheckUrlsProperty)((Object)BEANS.get(ServerCommonsConfigProperties.RemoteHealthCheckUrlsProperty.class))).getValue();

    @Override
    protected long getConfiguredTimeoutMillis() {
        return TimeUnit.SECONDS.toMillis(30L);
    }

    @Override
    public boolean isActive() {
        return !CollectionUtility.isEmpty(this.m_remoteUrls);
    }

    @Override
    protected boolean execCheckHealth(HealthCheckCategoryId category) {
        return this.checkHealthInternal(category, false);
    }

    public boolean checkHealthSilent() {
        return this.checkHealthInternal(null, true);
    }

    protected boolean checkHealthInternal(HealthCheckCategoryId category, boolean silent) {
        if (this.m_remoteUrls != null) {
            for (String remote : this.m_remoteUrls) {
                GenericUrl remoteUrl;
                GenericUrl genericUrl = remoteUrl = remote != null ? new GenericUrl(remote) : null;
                if (remoteUrl != null && category != null) {
                    remoteUrl.put("category", category.unwrap());
                }
                try {
                    HttpRequest req = ((DefaultHttpTransportManager)BEANS.get(DefaultHttpTransportManager.class)).getHttpRequestFactory().buildHeadRequest(remoteUrl);
                    req.getHeaders().setCacheControl("no-cache");
                    HttpResponse resp = req.execute();
                    int statusCode = resp.getStatusCode();
                    if (statusCode >= 200 && statusCode < 400) continue;
                    return false;
                }
                catch (IOException e) {
                    if (!silent || LOG.isDebugEnabled()) {
                        LOG.info("{} failed, message={}", new Object[]{this.getName(), e.getMessage(), LOG.isDebugEnabled() ? e : null});
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean acceptCategory(HealthCheckCategoryId category) {
        return Objects.equals((Object)category, (Object)IHealthChecker.Readiness.ID);
    }
}

