/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.healthcheck;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.healthcheck.HealthCheckCategoryId;
import org.eclipse.scout.rt.server.commons.healthcheck.HealthCheckResult;
import org.eclipse.scout.rt.server.commons.healthcheck.HealthCheckService;
import org.eclipse.scout.rt.server.commons.healthcheck.IHealthChecker;
import org.eclipse.scout.rt.server.commons.servlet.AbstractHttpServlet;
import org.eclipse.scout.rt.server.commons.servlet.HttpServletControl;
import org.eclipse.scout.rt.server.commons.servlet.ServletExceptionTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckServlet.class);
    public static final String QUERY_PARAMETER_NAME_CATEGORY = "category";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setAttribute("scout.noLog", (Object)"X");
        this.disableCaching(req, resp);
        ((HttpServletControl)BEANS.get(HttpServletControl.class)).doDefaults(this, req, resp);
        try {
            this.doChecks(req, resp);
        }
        catch (Throwable t) {
            LOG.error("HealthChecking crashed", t);
            throw ((ServletExceptionTranslator)BEANS.get(ServletExceptionTranslator.class)).translate(t);
        }
    }

    protected void disableCaching(HttpServletRequest req, HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "private, no-store, no-cache, max-age=0");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
    }

    protected void doChecks(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HealthCheckCategoryId category = this.parseCategory(req);
        HealthCheckResult result = ((HealthCheckService)BEANS.get(HealthCheckService.class)).check(category);
        int statusCode = result.getFailedChecks().isEmpty() ? 200 : 503;
        String output = this.generateOutput(statusCode, result, false);
        resp.setContentType("text/plain");
        resp.setStatus(statusCode);
        LazyValue detailedOutput = new LazyValue(() -> this.generateOutput(statusCode, result, true));
        boolean isDevelopmentMode = Platform.get().inDevelopmentMode();
        if (statusCode != 200) {
            LOG.warn("Status {}", (Object)StringUtility.replaceNewLines((String)((String)detailedOutput.get()), (String)", "));
        } else if (LOG.isDebugEnabled() || isDevelopmentMode) {
            LOG.debug("Status {}", (Object)StringUtility.replaceNewLines((String)((String)detailedOutput.get()), (String)", "));
        }
        resp.getWriter().print(isDevelopmentMode ? (String)detailedOutput.get() : output);
    }

    protected HealthCheckCategoryId parseCategory(HttpServletRequest req) {
        String inputCategory = StringUtility.nullIfEmpty((Object)req.getParameter(QUERY_PARAMETER_NAME_CATEGORY));
        HealthCheckCategoryId category = null;
        if (inputCategory != null && (category = (HealthCheckCategoryId)BEANS.all(IHealthChecker.IHealthCheckCategory.class).stream().map(IHealthChecker.IHealthCheckCategory::getId).filter(c -> Objects.equals(c.unwrap(), inputCategory)).findFirst().orElse(null)) == null) {
            LOG.error("Ignoring invalid category {} for health check", (Object)inputCategory);
        }
        return category;
    }

    protected String generateOutput(int statusCode, HealthCheckResult result, boolean includeDetails) {
        StringBuilder buf = new StringBuilder();
        buf.append(statusCode);
        buf.append(' ');
        buf.append(result.isSuccess() ? "OK" : "SERVICE_UNAVAILABLE");
        if (includeDetails) {
            for (IHealthChecker check : result.getAllChecks()) {
                buf.append('\n');
                buf.append(check.getName());
                buf.append(':');
                buf.append(result.getFailedChecks().contains(check) ? "ERROR" : "OK");
            }
        }
        return buf.toString();
    }
}

