/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.healthcheck;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.server.commons.healthcheck.HealthCheckCategoryId;
import org.eclipse.scout.rt.server.commons.healthcheck.HealthCheckResult;
import org.eclipse.scout.rt.server.commons.healthcheck.IHealthChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HealthCheckService {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckService.class);

    public HealthCheckResult check() {
        return this.check(null);
    }

    public HealthCheckResult check(HealthCheckCategoryId category) {
        List<IHealthChecker> checks = this.getActiveHealthCheckers(category);
        ArrayList<IHealthChecker> failed = new ArrayList<IHealthChecker>();
        RunContext context = this.execCreateRunContext();
        for (IHealthChecker check : checks) {
            try {
                if (check.checkHealth(context, category)) continue;
                failed.add(check);
            }
            catch (Throwable t) {
                LOG.error("HealthChecker[{}] failed", (Object)check.getName(), (Object)t);
                failed.add(check);
            }
        }
        return new HealthCheckResult(checks, failed);
    }

    protected RunContext execCreateRunContext() {
        return RunContexts.empty();
    }

    protected List<IHealthChecker> getActiveHealthCheckers(HealthCheckCategoryId category) {
        List all = BEANS.all(IHealthChecker.class);
        ArrayList<IHealthChecker> actives = new ArrayList<IHealthChecker>(all.size());
        for (IHealthChecker check : all) {
            try {
                if (this.execAcceptCheck(check, category)) {
                    actives.add(check);
                    continue;
                }
                LOG.debug("HealthChecker[{}] was ignored (called with category {})", (Object)check.getName(), (Object)category);
            }
            catch (Throwable t) {
                LOG.error("Active-check crashed with HealthChecker[{}]", (Object)check.getName(), (Object)t);
            }
        }
        return Collections.unmodifiableList(actives);
    }

    protected boolean execAcceptCheck(IHealthChecker check, HealthCheckCategoryId category) {
        return (category == null || check.acceptCategory(category)) && check.isActive();
    }
}

