/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.context;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.CorrelationId;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.servlet.IHttpServletRoundtrip;
import org.eclipse.scout.rt.server.commons.servlet.logging.ServletDiagnosticsProviderFactory;

@ApplicationScoped
public class HttpRunContextProducer {
    private final ServletDiagnosticsProviderFactory m_servletDiagProviderFactory = this.createServletDiagnosticsProviderFactory();
    private final CorrelationId m_correlationIdProvider = this.createCorrelationId();

    public RunContext produce(HttpServletRequest req, HttpServletResponse resp) {
        return this.produce(req, resp, null);
    }

    public RunContext produce(HttpServletRequest req, HttpServletResponse resp, RunContext existing) {
        RunContext contextToFill = existing;
        if (contextToFill == null) {
            contextToFill = RunContexts.copyCurrent((boolean)true);
        }
        return contextToFill.withSubject(Subject.current()).withCorrelationId(this.currentCorrelationId(req)).withThreadLocal(IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_REQUEST, (Object)req).withThreadLocal(IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_RESPONSE, (Object)resp).withDiagnostics(this.getServletDiagnosticsProviderFactory().getProviders(req, resp)).withLocale(req.getLocale()).withTransactionScope(TransactionScope.REQUIRES_NEW);
    }

    protected String currentCorrelationId(HttpServletRequest req) {
        String cid = req.getHeader("X-Scout-Correlation-Id");
        if (StringUtility.hasText((CharSequence)cid)) {
            return cid;
        }
        return this.getCorrelationIdProvider().newCorrelationId();
    }

    protected ServletDiagnosticsProviderFactory createServletDiagnosticsProviderFactory() {
        return (ServletDiagnosticsProviderFactory)BEANS.get(ServletDiagnosticsProviderFactory.class);
    }

    protected CorrelationId createCorrelationId() {
        return (CorrelationId)BEANS.get(CorrelationId.class);
    }

    protected CorrelationId getCorrelationIdProvider() {
        return this.m_correlationIdProvider;
    }

    protected ServletDiagnosticsProviderFactory getServletDiagnosticsProviderFactory() {
        return this.m_servletDiagProviderFactory;
    }
}

