/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.context;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.server.commons.context.HttpRunContextProducer;

public class HttpRunContextFilter
implements Filter {
    private HttpRunContextProducer m_producer;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_producer = this.createRunContextProducer();
    }

    protected HttpRunContextProducer createRunContextProducer() {
        return (HttpRunContextProducer)BEANS.get(HttpRunContextProducer.class);
    }

    protected HttpRunContextProducer getRunContextProducer() {
        return this.m_producer;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        this.buildRunContext(req, resp).run(() -> chain.doFilter(request, response));
    }

    protected RunContext buildRunContext(HttpServletRequest req, HttpServletResponse resp) {
        return this.getRunContextProducer().produce(req, resp);
    }

    public void destroy() {
        this.m_producer = null;
    }
}

