/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication;

import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class PathInfoFilter {
    private final Pattern m_pattern;

    public PathInfoFilter(String simplePattern) {
        this(PathInfoFilter.simplePatternListToRegex(simplePattern));
    }

    public PathInfoFilter(Pattern pattern) {
        this.m_pattern = pattern;
    }

    public static Pattern simplePatternListToRegex(String patList) {
        HashSet<Object> patSet = new HashSet<Object>();
        if (patList != null) {
            String[] stringArray = patList.split("[,\\s]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = stringArray[n2];
                if (!((String)(s = ((String)s).trim())).isEmpty()) {
                    if (!((String)s).startsWith("/")) {
                        s = "/" + (String)s;
                    }
                    if ((s = PathInfoFilter.simplePatternToRegex((String)s)) != null) {
                        patSet.add(s);
                    }
                }
                ++n2;
            }
        }
        if (patSet.isEmpty()) {
            return null;
        }
        return Pattern.compile("(" + CollectionUtility.format(patSet, (String)"|") + ")", 2);
    }

    public static String simplePatternToRegex(String s) {
        String r = Pattern.quote(s);
        r = r.replace("*", "\\E.*\\Q");
        return r;
    }

    public boolean accepts(String pathInfo) {
        return pathInfo != null && this.m_pattern != null && this.m_pattern.matcher(pathInfo).matches();
    }
}

