/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.AbstractBooleanConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.security.IPrincipalProducer;
import org.eclipse.scout.rt.platform.security.SimplePrincipalProducer;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.authentication.IAccessController;
import org.eclipse.scout.rt.server.commons.authentication.PathInfoFilter;
import org.eclipse.scout.rt.server.commons.authentication.ServletFilterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymousAccessController
implements IAccessController {
    private static final Logger LOG = LoggerFactory.getLogger(AnonymousAccessController.class);
    private AnonymousAuthConfig m_config;

    public AnonymousAccessController init() {
        this.init(new AnonymousAuthConfig());
        return this;
    }

    public AnonymousAccessController init(AnonymousAuthConfig config) {
        this.m_config = config;
        Assertions.assertNotNull((Object)this.m_config.getPrincipalProducer(), (String)"PrincipalProducer must not be null", (Object[])new Object[0]);
        return this;
    }

    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.m_config.isEnabled()) {
            return false;
        }
        Principal principal = this.m_config.getPrincipalProducer().produce(this.m_config.getUsername());
        ServletFilterHelper helper = (ServletFilterHelper)BEANS.get(ServletFilterHelper.class);
        if (this.m_config.isPutPrincipalOnSession()) {
            if (request.getSession(false) == null && this.m_config.getAbortOnNoSessionFilter().accepts(request.getPathInfo())) {
                LOG.debug("Aborting filter chain for request {}", (Object)request.getPathInfo());
                return false;
            }
            helper.putPrincipalOnSession(request, principal);
        }
        helper.continueChainAsSubject(principal, request, response, chain);
        return true;
    }

    @Override
    public void destroy() {
    }

    public static class AnonymousAuthConfig {
        private boolean m_enabled = (Boolean)CONFIG.getPropertyValue(EnabledProperty.class);
        private IPrincipalProducer m_principalProducer = (IPrincipalProducer)BEANS.get(SimplePrincipalProducer.class);
        private String m_username = "anonymous";
        private boolean m_putPrincipalOnSession = true;
        private PathInfoFilter m_abortOnNoSessionFilter;
        private String m_defaultAbortOnNoSessionFilter = "/ui-notifications,/*/ui-notifications";

        public AnonymousAuthConfig() {
            this.withAbortOnNoSessionFilter("");
        }

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public AnonymousAuthConfig withEnabled(boolean enabled) {
            this.m_enabled = enabled;
            return this;
        }

        public IPrincipalProducer getPrincipalProducer() {
            return this.m_principalProducer;
        }

        public AnonymousAuthConfig withPrincipalProducer(IPrincipalProducer principalProducer) {
            this.m_principalProducer = principalProducer;
            return this;
        }

        public String getUsername() {
            return this.m_username;
        }

        public AnonymousAuthConfig withUsername(String username) {
            this.m_username = username;
            return this;
        }

        public boolean isPutPrincipalOnSession() {
            return this.m_putPrincipalOnSession;
        }

        public AnonymousAuthConfig withPutPrincipalOnSession(boolean putPrincipalOnSession) {
            this.m_putPrincipalOnSession = putPrincipalOnSession;
            return this;
        }

        public PathInfoFilter getAbortOnNoSessionFilter() {
            return this.m_abortOnNoSessionFilter;
        }

        public AnonymousAuthConfig withAbortOnNoSessionFilter(String abortFilter) {
            Assertions.assertNotNull((Object)abortFilter);
            this.m_abortOnNoSessionFilter = new PathInfoFilter(StringUtility.join((String)",", (Object[])new Object[]{abortFilter, this.getDefaultAbortOnNoSessionFilter()}));
            return this;
        }

        public String getDefaultAbortOnNoSessionFilter() {
            return this.m_defaultAbortOnNoSessionFilter;
        }

        public AnonymousAuthConfig withDefaultAbortOnNoSessionFilter(String defaultAbortOnNoSessionFilter) {
            this.m_defaultAbortOnNoSessionFilter = defaultAbortOnNoSessionFilter;
            return this;
        }
    }

    public static class EnabledProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.auth.anonymousEnabled";
        }

        public String description() {
            return String.format("Specifies if the '%s' is enabled. Therefore, if a security filter uses this controller no login is required.", AnonymousAccessController.class.getSimpleName());
        }

        public Boolean getDefaultValue() {
            return true;
        }
    }
}

