/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.security;

import jakarta.annotation.PostConstruct;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.cache.AbstractCacheWrapper;
import org.eclipse.scout.rt.platform.cache.AllCacheEntryFilter;
import org.eclipse.scout.rt.platform.cache.ICache;
import org.eclipse.scout.rt.platform.cache.ICacheBuilder;
import org.eclipse.scout.rt.platform.cache.ICacheEntryFilter;
import org.eclipse.scout.rt.platform.cache.ICacheInvalidationListener;
import org.eclipse.scout.rt.platform.cache.ICacheValueResolver;
import org.eclipse.scout.rt.platform.cache.KeyCacheEntryFilter;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.security.IPermissionCollection;
import org.eclipse.scout.rt.security.NonePermissionCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccessControlService<K>
implements IAccessControlService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAccessControlService.class);
    public static final String ACCESS_CONTROL_SERVICE_CACHE_ID = AbstractAccessControlService.class.getName();
    private volatile Pattern[] m_userIdSearchPatterns = new Pattern[]{Pattern.compile("(.*)")};
    private volatile ICache<K, IPermissionCollection> m_cache;
    private volatile IFastListenerList<ICacheInvalidationListener<Object, IPermissionCollection>> m_invalidationListeners;

    @PostConstruct
    protected void initCache() {
        this.m_invalidationListeners = new FastListenerList();
        this.m_cache = this.createCacheBuilder().build();
    }

    protected Pattern[] getUserIdSearchPatterns() {
        return this.m_userIdSearchPatterns;
    }

    protected void setUserIdSearchPatterns(Pattern ... patterns) {
        this.m_userIdSearchPatterns = Objects.requireNonNullElseGet(patterns, () -> new Pattern[0]);
    }

    protected void setUserIdSearchPatterns(String ... patterns) {
        Pattern[] a = new Pattern[patterns.length];
        int i = 0;
        while (i < a.length) {
            a[i] = Pattern.compile(patterns[i]);
            ++i;
        }
        this.setUserIdSearchPatterns(a);
    }

    protected ICacheBuilder<K, IPermissionCollection> createCacheBuilder() {
        ICacheBuilder cacheBuilder = (ICacheBuilder)BEANS.get(ICacheBuilder.class);
        return cacheBuilder.withCacheId(ACCESS_CONTROL_SERVICE_CACHE_ID).withValueResolver(this.createCacheValueResolver()).withShared(true).withClusterEnabled(true).withTransactional(true).withTransactionalFastForward(true).withAdditionalCustomWrapper(InvalidationListenerWrapper.class, new Object[0]).withTimeToLive(Long.valueOf(1L), TimeUnit.HOURS, false);
    }

    @Override
    public void addInvalidationListener(ICacheInvalidationListener<Object, IPermissionCollection> listener) {
        if (listener != null) {
            this.m_invalidationListeners.add(listener);
        }
    }

    @Override
    public void removeInvalidationListener(ICacheInvalidationListener<Object, IPermissionCollection> listener) {
        if (listener != null) {
            this.m_invalidationListeners.remove(listener);
        }
    }

    @Override
    public List<ICacheInvalidationListener<Object, IPermissionCollection>> getInvalidationListeners() {
        return this.m_invalidationListeners.list();
    }

    protected ICacheValueResolver<K, IPermissionCollection> createCacheValueResolver() {
        return this::execLoadPermissions;
    }

    protected ICache<K, IPermissionCollection> getCache() {
        return this.m_cache;
    }

    protected abstract K getCurrentUserCacheKey();

    protected abstract IPermissionCollection execLoadPermissions(K var1);

    @Override
    public String getUserIdOfCurrentSubject() {
        return this.getUserId(Subject.current());
    }

    @Override
    public String getUserIdForCacheKey(Object cacheKey) {
        if (cacheKey instanceof String) {
            return (String)cacheKey;
        }
        LOG.error("By default only userId cacheKeys are supported. Overwrite this method for custom cacheKeys.");
        return null;
    }

    @Override
    public String getUserId(Subject subject) {
        if (subject == null) {
            return null;
        }
        for (Principal p : subject.getPrincipals()) {
            String name = p.getName().toLowerCase();
            Pattern[] patternArray = this.m_userIdSearchPatterns;
            int n = this.m_userIdSearchPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pat = patternArray[n2];
                Matcher m = pat.matcher(name);
                if (m.matches()) {
                    return m.group(1);
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IPermissionCollection getPermissions() {
        K currentUserCacheKey = this.getCurrentUserCacheKey();
        IPermissionCollection permissions = (IPermissionCollection)this.getCache().get(currentUserCacheKey);
        LOG.trace("getPermissions() called for {}, returned {}", currentUserCacheKey, (Object)permissions);
        if (permissions == null) {
            LOG.error("getPermissions() called for {}, returned {}", currentUserCacheKey, (Object)permissions);
        }
        return permissions == null ? (IPermissionCollection)BEANS.get(NonePermissionCollection.class) : permissions;
    }

    @Override
    public void clearCache() {
        this.getCache().invalidate((ICacheEntryFilter)new AllCacheEntryFilter(), true);
    }

    @Override
    public void clearCacheOfCurrentUser() {
        this.clearCache(Collections.singleton(this.getCurrentUserCacheKey()));
    }

    protected void clearCache(Collection<? extends K> cacheKeys) {
        if (cacheKeys == null) {
            return;
        }
        KeyCacheEntryFilter filter = new KeyCacheEntryFilter(cacheKeys);
        if (filter.getKeys().isEmpty()) {
            return;
        }
        this.getCache().invalidate((ICacheEntryFilter)filter, true);
    }

    protected static class InvalidationListenerWrapper
    extends AbstractCacheWrapper<Object, IPermissionCollection> {
        public InvalidationListenerWrapper(ICache<Object, IPermissionCollection> delegate) {
            super(delegate);
        }

        public void invalidate(ICacheEntryFilter<Object, IPermissionCollection> filter, boolean propagate) {
            super.invalidate(filter, propagate);
            ((IAccessControlService)BEANS.get(IAccessControlService.class)).getInvalidationListeners().forEach(l -> l.invalidated(filter, propagate));
        }
    }
}

