/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api.marshaller;

import java.io.IOException;
import java.util.Map;
import org.eclipse.scout.rt.mom.api.marshaller.IMarshaller;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.exception.DefaultRuntimeExceptionTranslator;
import org.eclipse.scout.rt.platform.serialization.IObjectSerializer;
import org.eclipse.scout.rt.platform.serialization.SerializationUtility;

@Bean
public class ObjectMarshaller
implements IMarshaller {
    protected static final String CTX_PROP_OBJECT_TYPE = "x-scout.mom.object.objecttype";

    @Override
    public Object marshall(Object transferObject, Map<String, String> context) {
        if (transferObject == null) {
            return null;
        }
        try {
            IObjectSerializer serializer = SerializationUtility.createObjectSerializer();
            byte[] bytes = serializer.serialize(transferObject);
            context.put(CTX_PROP_OBJECT_TYPE, transferObject.getClass().getName());
            return bytes;
        }
        catch (IOException e) {
            throw ((DefaultRuntimeExceptionTranslator)BEANS.get(DefaultRuntimeExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    @Override
    public Object unmarshall(Object data, Map<String, String> context) {
        byte[] bytes = (byte[])data;
        if (bytes == null) {
            return null;
        }
        try {
            Class<?> objectType = Class.forName(context.get(CTX_PROP_OBJECT_TYPE));
            IObjectSerializer serializer = SerializationUtility.createObjectSerializer();
            return serializer.deserialize(bytes, objectType);
        }
        catch (IOException | ClassNotFoundException e) {
            throw ((DefaultRuntimeExceptionTranslator)BEANS.get(DefaultRuntimeExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    @Override
    public int getMessageType() {
        return 2;
    }
}

