/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api.marshaller;

import java.util.Map;
import org.eclipse.scout.rt.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.mom.api.marshaller.IMarshaller;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.exception.DefaultRuntimeExceptionTranslator;

@Bean
public class JsonMarshaller
implements IMarshaller {
    public static final String CTX_PROP_OBJECT_TYPE = "x-scout.mom.json.objecttype";
    protected final IDataObjectMapper m_dataObjectMapper = this.createDataObjectMapper();

    @Override
    public Object marshall(Object transferObject, Map<String, String> context) {
        if (transferObject == null) {
            return null;
        }
        context.put(CTX_PROP_OBJECT_TYPE, transferObject.getClass().getName());
        return this.m_dataObjectMapper.writeValue(transferObject);
    }

    @Override
    public Object unmarshall(Object data, Map<String, String> context) {
        String jsonText = (String)data;
        if (jsonText == null) {
            return null;
        }
        try {
            Class<?> objectType = Class.forName(context.get(CTX_PROP_OBJECT_TYPE));
            return this.m_dataObjectMapper.readValue(jsonText, objectType);
        }
        catch (ClassNotFoundException e) {
            throw ((DefaultRuntimeExceptionTranslator)BEANS.get(DefaultRuntimeExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    @Override
    public int getMessageType() {
        return 1;
    }

    protected IDataObjectMapper createDataObjectMapper() {
        return (IDataObjectMapper)BEANS.get(IDataObjectMapper.class);
    }
}

